/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodType;
import org.apache.bval.cdi.BValAnnotatedType;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValInterceptor;
import org.apache.bval.cdi.ValidatorBean;
import org.apache.bval.cdi.ValidatorFactoryBean;
import org.apache.commons.lang3.Validate;

public class BValExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(BValExtension.class.getName());
    private static final AnnotatedTypeFilter DEFAULT_ANNOTATED_TYPE_FILTER;
    private static AnnotatedTypeFilter annotatedTypeFilter;
    private boolean validatorFound = Boolean.getBoolean("bval.in-container");
    private boolean validatorFactoryFound = Boolean.getBoolean("bval.in-container");
    private boolean validBean;
    private boolean validConstructors;
    private boolean validBusinessMethods;
    private boolean validGetterMethods;
    private final Configuration<?> config = Validation.byDefaultProvider().configure();
    private ValidatorFactory factory;
    private Validator validator;
    private Set<ExecutableType> globalExecutableTypes;
    private boolean isExecutableValidationEnabled;

    public static void setAnnotatedTypeFilter(AnnotatedTypeFilter annotatedTypeFilter) {
        BValExtension.annotatedTypeFilter = (AnnotatedTypeFilter)Validate.notNull((Object)annotatedTypeFilter);
    }

    public BValExtension() {
        try {
            BootstrapConfiguration bootstrap = this.config.getBootstrapConfiguration();
            this.globalExecutableTypes = Collections.unmodifiableSet(BValExtension.convertToRuntimeTypes(bootstrap.getDefaultValidatedExecutableTypes()));
            this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
            this.validBean = this.globalExecutableTypes.contains(ExecutableType.IMPLICIT) || this.globalExecutableTypes.contains(ExecutableType.ALL);
            this.validConstructors = this.validBean || this.globalExecutableTypes.contains(ExecutableType.CONSTRUCTORS);
            this.validBusinessMethods = this.validBean || this.globalExecutableTypes.contains(ExecutableType.NON_GETTER_METHODS);
            this.validGetterMethods = this.globalExecutableTypes.contains(ExecutableType.ALL) || this.globalExecutableTypes.contains(ExecutableType.GETTER_METHODS);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            this.globalExecutableTypes = Collections.emptySet();
            this.isExecutableValidationEnabled = false;
        }
    }

    private void ensureFactoryValidator() {
        if (this.validator != null) {
            return;
        }
        this.config.addProperty("bval.before.cdi", "true");
        if (this.factory == null) {
            this.factory = this.config.buildValidatorFactory();
        }
        this.validator = this.factory.getValidator();
    }

    private static Set<ExecutableType> convertToRuntimeTypes(Set<ExecutableType> defaultValidatedExecutableTypes) {
        EnumSet<ExecutableType> types = EnumSet.noneOf(ExecutableType.class);
        for (ExecutableType type : defaultValidatedExecutableTypes) {
            if (ExecutableType.NONE == type) continue;
            if (ExecutableType.ALL == type) {
                types.add(ExecutableType.CONSTRUCTORS);
                types.add(ExecutableType.NON_GETTER_METHODS);
                types.add(ExecutableType.GETTER_METHODS);
                break;
            }
            if (ExecutableType.IMPLICIT == type) {
                types.add(ExecutableType.CONSTRUCTORS);
                types.add(ExecutableType.NON_GETTER_METHODS);
                continue;
            }
            types.add(type);
        }
        return types;
    }

    public Set<ExecutableType> getGlobalExecutableTypes() {
        return this.globalExecutableTypes;
    }

    public void addBvalBinding(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addInterceptorBinding(BValBinding.class, new Annotation[0]);
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(BValInterceptor.class));
    }

    public <A> void processAnnotatedType(@Observes ProcessAnnotatedType<A> pat) {
        if (!this.isExecutableValidationEnabled) {
            return;
        }
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (!annotatedTypeFilter.accept(annotatedType)) {
            return;
        }
        Class javaClass = annotatedType.getJavaClass();
        int modifiers = javaClass.getModifiers();
        if (!(javaClass.isInterface() || Modifier.isFinal(modifiers) || Modifier.isAbstract(modifiers))) {
            try {
                this.ensureFactoryValidator();
                try {
                    BeanDescriptor classConstraints = this.validator.getConstraintsForClass(javaClass);
                    if (annotatedType.isAnnotationPresent(ValidateOnExecution.class) || BValExtension.hasValidationAnnotation(annotatedType.getMethods()) || BValExtension.hasValidationAnnotation(annotatedType.getConstructors()) || classConstraints != null && (this.validBean && classConstraints.isBeanConstrained() || this.validConstructors && !classConstraints.getConstrainedConstructors().isEmpty() || this.validBusinessMethods && !classConstraints.getConstrainedMethods(MethodType.NON_GETTER, new MethodType[0]).isEmpty() || this.validGetterMethods && !classConstraints.getConstrainedMethods(MethodType.GETTER, new MethodType[0]).isEmpty())) {
                        BValAnnotatedType bValAnnotatedType = new BValAnnotatedType(annotatedType);
                        pat.setAnnotatedType(bValAnnotatedType);
                    }
                }
                catch (NoClassDefFoundError ncdfe) {}
            }
            catch (ValidationException ve) {
                LOGGER.log(Level.FINEST, ve.getMessage(), ve);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage());
            }
        }
    }

    private static <A> boolean hasValidationAnnotation(Collection<? extends AnnotatedCallable<? super A>> methods) {
        for (AnnotatedCallable<A> annotatedCallable : methods) {
            if (!annotatedCallable.isAnnotationPresent(ValidateOnExecution.class)) continue;
            return true;
        }
        return false;
    }

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (this.validatorFound && this.validatorFactoryFound) {
            return;
        }
        Bean bean = processBeanEvent.getBean();
        if (ValidatorBean.class.isInstance(bean) || ValidatorFactoryBean.class.isInstance(bean)) {
            return;
        }
        Set types = bean.getTypes();
        if (!this.validatorFound) {
            this.validatorFound = types.contains(Validator.class);
        }
        if (!this.validatorFactoryFound) {
            this.validatorFactoryFound = types.contains(ValidatorFactory.class);
        }
    }

    public void addBValBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.factory != null) {
            this.factory.close();
        }
        this.cdiIntegration(afterBeanDiscovery, beanManager);
    }

    private void cdiIntegration(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        try {
            this.config.addProperty("bval.before.cdi", "false");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.validatorFactoryFound) {
            try {
                this.factory = this.config.buildValidatorFactory();
                afterBeanDiscovery.addBean((Bean)new ValidatorFactoryBean(this.factory));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (!this.validatorFound) {
            try {
                if (this.validatorFactoryFound) {
                    this.factory = this.config.buildValidatorFactory();
                }
                afterBeanDiscovery.addBean((Bean)new ValidatorBean(this.factory, this.factory.getValidator()));
                this.validatorFound = true;
            }
            catch (Exception e) {
                afterBeanDiscovery.addBean((Bean)new ValidatorBean(this.factory, null));
                this.validatorFound = true;
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static <T> Releasable<T> inject(Class<T> clazz) {
        try {
            BeanManager beanManager = CDI.current().getBeanManager();
            if (beanManager == null) {
                return null;
            }
            AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
            InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
            CreationalContext context = beanManager.createCreationalContext(null);
            Object instance = it.produce(context);
            it.inject(instance, context);
            it.postConstruct(instance);
            return new Releasable(context, it, instance);
        }
        catch (Exception e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    static {
        annotatedTypeFilter = DEFAULT_ANNOTATED_TYPE_FILTER = new AnnotatedTypeFilter(){

            @Override
            public boolean accept(AnnotatedType<?> annotatedType) {
                return !annotatedType.getJavaClass().getName().startsWith("org.apache.bval.");
            }
        };
    }

    public static interface AnnotatedTypeFilter {
        public boolean accept(AnnotatedType<?> var1);
    }

    public static class Releasable<T> {
        private final CreationalContext<T> context;
        private final InjectionTarget<T> injectionTarget;
        private final T instance;

        private Releasable(CreationalContext<T> context, InjectionTarget<T> injectionTarget, T instance) {
            this.context = context;
            this.injectionTarget = injectionTarget;
            this.instance = instance;
        }

        public void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
                this.injectionTarget.dispose(this.instance);
                this.context.release();
            }
            catch (Exception e) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

