/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.DeterministicCodeOptimizer;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Visitor;

public class ClassDeclarationFinder
extends Visitor {
    protected final ClassDeclarationFinder parent;
    protected final List<MemberDeclaration> addedDeclarations = new ArrayList<MemberDeclaration>();
    private final Function1<ClassDeclarationFinder, ClassDeclarationFinder> childFactory;
    private static final Function1<ClassDeclarationFinder, ClassDeclarationFinder> DEFAULT_CHILD_FACTORY = new Function1<ClassDeclarationFinder, ClassDeclarationFinder>(){

        @Override
        public ClassDeclarationFinder apply(ClassDeclarationFinder a0) {
            return new DeterministicCodeOptimizer(a0);
        }
    };

    public static ClassDeclarationFinder create() {
        return ClassDeclarationFinder.create(DEFAULT_CHILD_FACTORY);
    }

    public static ClassDeclarationFinder create(Class<? extends ClassDeclarationFinder> optimizingClass) {
        return ClassDeclarationFinder.create(ClassDeclarationFinder.newChildCreator(optimizingClass));
    }

    public static ClassDeclarationFinder create(Function1<ClassDeclarationFinder, ClassDeclarationFinder> childFactory) {
        return new ClassDeclarationFinder(childFactory);
    }

    private static Function1<ClassDeclarationFinder, ClassDeclarationFinder> newChildCreator(Class<? extends ClassDeclarationFinder> optimizingClass) {
        try {
            final Constructor<? extends ClassDeclarationFinder> constructor = optimizingClass.getConstructor(ClassDeclarationFinder.class);
            return new Function1<ClassDeclarationFinder, ClassDeclarationFinder>(){

                @Override
                public ClassDeclarationFinder apply(ClassDeclarationFinder a0) {
                    try {
                        return (ClassDeclarationFinder)constructor.newInstance(a0);
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException("Unable to create optimizer via " + constructor, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Unable to create optimizer via " + constructor, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Unable to create optimizer via " + constructor, e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Given class " + optimizingClass + "does not support (ClassDeclarationFinder) constructor", e);
        }
    }

    private ClassDeclarationFinder(Function1<ClassDeclarationFinder, ClassDeclarationFinder> childFactory) {
        this.parent = null;
        this.childFactory = childFactory;
    }

    protected ClassDeclarationFinder(ClassDeclarationFinder parent) {
        this.parent = parent;
        this.childFactory = parent.childFactory;
    }

    @Override
    public Visitor preVisit(NewExpression newExpression) {
        if (newExpression.memberDeclarations == null) {
            return this;
        }
        ClassDeclarationFinder visitor = this.goDeeper();
        visitor.learnFinalStaticDeclarations(newExpression.memberDeclarations);
        return visitor;
    }

    @Override
    public Visitor preVisit(ClassDeclaration classDeclaration) {
        ClassDeclarationFinder visitor = this.goDeeper();
        visitor.learnFinalStaticDeclarations(classDeclaration.memberDeclarations);
        return visitor;
    }

    @Override
    public Expression visit(NewExpression newExpression, List<Expression> arguments, List<MemberDeclaration> memberDeclarations) {
        if (this.parent == null) {
            arguments = newExpression.arguments;
        } else if (memberDeclarations != null) {
            arguments = Expressions.acceptExpressions(newExpression.arguments, this.parent);
        }
        Expression result = super.visit(newExpression, arguments, memberDeclarations);
        if (memberDeclarations == null) {
            return this.tryOptimizeNewInstance((NewExpression)result);
        }
        memberDeclarations = this.optimizeDeclarations(memberDeclarations);
        return super.visit((NewExpression)result, arguments, memberDeclarations);
    }

    protected void learnFinalStaticDeclarations(List<MemberDeclaration> memberDeclarations) {
    }

    protected Expression tryOptimizeNewInstance(NewExpression newExpression) {
        return newExpression;
    }

    @Override
    public ClassDeclaration visit(ClassDeclaration classDeclaration, List<MemberDeclaration> memberDeclarations) {
        memberDeclarations = this.optimizeDeclarations(memberDeclarations);
        return super.visit(classDeclaration, memberDeclarations);
    }

    protected List<MemberDeclaration> optimizeDeclarations(List<MemberDeclaration> memberDeclarations) {
        if (this.addedDeclarations.isEmpty()) {
            return memberDeclarations;
        }
        ArrayList<MemberDeclaration> newDecls = new ArrayList<MemberDeclaration>(memberDeclarations.size() + this.addedDeclarations.size());
        newDecls.addAll(memberDeclarations);
        newDecls.addAll(this.addedDeclarations);
        return newDecls;
    }

    protected boolean isConstant(Expression expression) {
        return false;
    }

    protected boolean isConstant(Iterable<? extends Expression> list) {
        for (Expression expression : list) {
            if (this.isConstant(expression)) continue;
            return false;
        }
        return true;
    }

    protected ParameterExpression findDeclaredExpression(Expression expression) {
        return null;
    }

    protected boolean hasField(String name) {
        return false;
    }

    protected ClassDeclarationFinder goDeeper() {
        return this.childFactory.apply(this);
    }
}

