/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Timing {
    private final long value;
    private final TimeUnit unit;
    private final int waitingMultiple;
    private static final int DEFAULT_SECONDS = 10;
    private static final int DEFAULT_WAITING_MULTIPLE = 5;
    private static final double SESSION_MULTIPLE = 1.5;
    private static final double SESSION_SLEEP_MULTIPLE = 2.625;

    public Timing() {
        this((double)Integer.getInteger("timing-multiple", 1).intValue(), Timing.getWaitingMultiple());
    }

    public Timing(double multiple) {
        this((long)(10.0 * multiple), TimeUnit.SECONDS, Timing.getWaitingMultiple());
    }

    public Timing(double multiple, int waitingMultiple) {
        this((long)(10.0 * multiple), TimeUnit.SECONDS, waitingMultiple);
    }

    public Timing(long value, TimeUnit unit) {
        this(value, unit, Timing.getWaitingMultiple());
    }

    public Timing(long value, TimeUnit unit, int waitingMultiple) {
        this.value = value;
        this.unit = unit;
        this.waitingMultiple = waitingMultiple;
    }

    public int milliseconds() {
        return (int)TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }

    public int seconds() {
        return (int)this.value;
    }

    public boolean awaitLatch(CountDownLatch latch) {
        Timing m = this.forWaiting();
        try {
            return latch.await(m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean acquireSemaphore(Semaphore semaphore) {
        Timing m = this.forWaiting();
        try {
            return semaphore.tryAcquire(m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean acquireSemaphore(Semaphore semaphore, int n) {
        Timing m = this.forWaiting();
        try {
            return semaphore.tryAcquire(n, m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Timing multiple(double n) {
        return new Timing((int)((double)this.value * n), this.unit);
    }

    public Timing multiple(double n, int waitingMultiple) {
        return new Timing((int)((double)this.value * n), this.unit, waitingMultiple);
    }

    public Timing forWaiting() {
        return this.multiple(this.waitingMultiple);
    }

    public Timing forSessionSleep() {
        return this.multiple(2.625, 1);
    }

    public Timing forSleepingABit() {
        return this.multiple(0.25);
    }

    public void sleepABit() throws InterruptedException {
        this.forSleepingABit().sleep();
    }

    public void sleep() throws InterruptedException {
        this.unit.sleep(this.value);
    }

    public int session() {
        return this.multiple(1.5).milliseconds();
    }

    public int connection() {
        return this.milliseconds();
    }

    private static Integer getWaitingMultiple() {
        return Integer.getInteger("timing-waiting-multiple", 5);
    }
}

