/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.utils.CloseableExecutorService;
import org.apache.curator.x.discovery.DownInstancePolicy;
import org.apache.curator.x.discovery.InstanceFilter;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceCacheBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.details.DownInstanceManager;
import org.apache.curator.x.discovery.details.FilteredInstanceProvider;
import org.apache.curator.x.discovery.details.InstanceProvider;
import org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceProviderImpl<T>
implements ServiceProvider<T> {
    private final ServiceCache<T> cache;
    private final InstanceProvider<T> instanceProvider;
    private final ServiceDiscoveryImpl<T> discovery;
    private final ProviderStrategy<T> providerStrategy;
    private final DownInstanceManager<T> downInstanceManager;

    public ServiceProviderImpl(ServiceDiscoveryImpl<T> discovery, String serviceName, ProviderStrategy<T> providerStrategy, ThreadFactory threadFactory, List<InstanceFilter<T>> filters, DownInstancePolicy downInstancePolicy) {
        this(discovery, serviceName, providerStrategy, threadFactory, null, filters, downInstancePolicy);
    }

    public ServiceProviderImpl(ServiceDiscoveryImpl<T> discovery, String serviceName, ProviderStrategy<T> providerStrategy, CloseableExecutorService executorService, List<InstanceFilter<T>> filters, DownInstancePolicy downInstancePolicy) {
        this(discovery, serviceName, providerStrategy, null, executorService, filters, downInstancePolicy);
    }

    protected ServiceProviderImpl(ServiceDiscoveryImpl<T> discovery, String serviceName, ProviderStrategy<T> providerStrategy, ThreadFactory threadFactory, CloseableExecutorService executorService, List<InstanceFilter<T>> filters, DownInstancePolicy downInstancePolicy) {
        this.discovery = discovery;
        this.providerStrategy = providerStrategy;
        this.downInstanceManager = new DownInstanceManager(downInstancePolicy);
        ServiceCacheBuilder<T> builder = discovery.serviceCacheBuilder().name(serviceName);
        if (executorService != null) {
            builder.executorService(executorService);
        } else {
            builder.threadFactory(threadFactory);
        }
        this.cache = builder.build();
        ArrayList localFilters = Lists.newArrayList(filters);
        localFilters.add(this.downInstanceManager);
        localFilters.add(new InstanceFilter<T>(){

            public boolean apply(ServiceInstance<T> instance) {
                return instance.isEnabled();
            }
        });
        this.instanceProvider = new FilteredInstanceProvider<T>(this.cache, localFilters);
    }

    @Override
    public void start() throws Exception {
        this.cache.start();
        this.discovery.providerOpened(this);
    }

    @Override
    public void close() throws IOException {
        this.discovery.providerClosed(this);
        this.cache.close();
    }

    @Override
    public Collection<ServiceInstance<T>> getAllInstances() throws Exception {
        return this.instanceProvider.getInstances();
    }

    @Override
    public ServiceInstance<T> getInstance() throws Exception {
        return this.providerStrategy.getInstance(this.instanceProvider);
    }

    @Override
    public void noteError(ServiceInstance<T> instance) {
        this.downInstanceManager.add(instance);
    }
}

