/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweDecryptingFilter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;

@Priority(value=1001)
public class JweClientResponseFilter
extends AbstractJweDecryptingFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext req, ClientResponseContext res) throws IOException {
        JweDecryptionOutput out = this.decrypt(res.getEntityStream());
        byte[] bytes = out.getContent();
        res.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        res.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(out.getHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            res.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }
}

