/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@PreMatching
@Priority(value=1001)
public class JwsContainerRequestFilter
extends AbstractJwsReaderProvider
implements ContainerRequestFilter {
    private static final String JWS_CONTEXT_PROPERTY = "org.apache.cxf.jws.context";

    public void filter(ContainerRequestContext context) throws IOException {
        if ("GET".equals(context.getMethod())) {
            return;
        }
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        JwsCompactConsumer p = new JwsCompactConsumer(IOUtils.readStringFromStream((InputStream)context.getEntityStream()));
        if (!p.verifySignatureWith(theSigVerifier)) {
            context.abortWith(JAXRSUtils.toResponse((int)400));
            return;
        }
        this.validateRequestContextProperty(p);
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(p.getJoseHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }

    protected void validateRequestContextProperty(JwsCompactConsumer c) {
        Object requestContext = JAXRSUtils.getCurrentMessage().get((Object)JWS_CONTEXT_PROPERTY);
        Object headerContext = c.getJoseHeaders().getHeader(JWS_CONTEXT_PROPERTY);
        if (requestContext == null && headerContext == null) {
            return;
        }
        if (requestContext == null && headerContext != null || requestContext != null && headerContext == null || !requestContext.equals(headerContext)) {
            throw new SecurityException();
        }
    }
}

