/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jaxrs.PrivateKeyPasswordProvider;
import org.apache.cxf.security.SecurityContext;

public final class KeyManagementUtils {
    public static final String RSSEC_KEY_STORE_TYPE = "rs.security.keystore.type";
    public static final String RSSEC_KEY_STORE_PSWD = "rs.security.keystore.password";
    public static final String RSSEC_KEY_PSWD = "rs.security.key.password";
    public static final String RSSEC_KEY_STORE_ALIAS = "rs.security.keystore.alias";
    public static final String RSSEC_KEY_STORE_ALIASES = "rs.security.keystore.aliases";
    public static final String RSSEC_KEY_STORE_FILE = "rs.security.keystore.file";
    public static final String RSSEC_PRINCIPAL_NAME = "rs.security.principal.name";
    public static final String RSSEC_KEY_PSWD_PROVIDER = "rs.security.key.password.provider";
    public static final String RSSEC_SIG_KEY_PSWD_PROVIDER = "rs.security.signature.key.password.provider";
    public static final String RSSEC_DECRYPT_KEY_PSWD_PROVIDER = "rs.security.decryption.key.password.provider";

    private KeyManagementUtils() {
    }

    public static PublicKey loadPublicKey(Message m, Properties props) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        return CryptoUtils.loadPublicKey((KeyStore)keyStore, (String)props.getProperty(RSSEC_KEY_STORE_ALIAS));
    }

    public static PublicKey loadPublicKey(Message m, String keyStoreLocProp) {
        return KeyManagementUtils.loadPublicKey(m, keyStoreLocProp, null);
    }

    public static PublicKey loadPublicKey(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault) {
        String keyStoreLoc = KeyManagementUtils.getMessageProperty(m, keyStoreLocPropPreferred, keyStoreLocPropDefault);
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = ResourceUtils.loadProperties((String)keyStoreLoc, (Bus)bus);
            return KeyManagementUtils.loadPublicKey(m, props);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static String getMessageProperty(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault) {
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)keyStoreLocPropPreferred, (String)keyStoreLocPropDefault);
        if (propLoc == null) {
            throw new SecurityException();
        }
        return propLoc;
    }

    public static PrivateKey loadPrivateKey(Properties props, Bus bus, PrivateKeyPasswordProvider provider) {
        KeyStore keyStore = KeyManagementUtils.loadKeyStore(props, bus);
        return KeyManagementUtils.loadPrivateKey(keyStore, props, bus, provider);
    }

    public static PrivateKey loadPrivateKey(KeyStore keyStore, Properties props, Bus bus, PrivateKeyPasswordProvider provider) {
        String keyPswd = props.getProperty(RSSEC_KEY_PSWD);
        String alias = props.getProperty(RSSEC_KEY_STORE_ALIAS);
        char[] keyPswdChars = provider != null ? provider.getPassword(props) : (char[])(keyPswd != null ? keyPswd.toCharArray() : null);
        return CryptoUtils.loadPrivateKey((KeyStore)keyStore, (char[])keyPswdChars, (String)alias);
    }

    public static PrivateKey loadPrivateKey(Message m, String keyStoreLocProp, String passwordProviderProp) {
        return KeyManagementUtils.loadPrivateKey(m, keyStoreLocProp, null, passwordProviderProp);
    }

    public static PrivateKey loadPrivateKey(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault, String passwordProviderProp) {
        String keyStoreLoc = KeyManagementUtils.getMessageProperty(m, keyStoreLocPropPreferred, keyStoreLocPropDefault);
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = ResourceUtils.loadProperties((String)keyStoreLoc, (Bus)bus);
            return KeyManagementUtils.loadPrivateKey(m, props, passwordProviderProp);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static PrivateKey loadPrivateKey(Message m, Properties props, String passwordProviderProp) {
        Principal p;
        SecurityContext sc;
        Bus bus = m.getExchange().getBus();
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        PrivateKeyPasswordProvider cb = (PrivateKeyPasswordProvider)m.getContextualProperty(passwordProviderProp);
        if (cb != null && m.getExchange().getInMessage() != null && (sc = (SecurityContext)m.getExchange().getInMessage().get(SecurityContext.class)) != null && (p = sc.getUserPrincipal()) != null) {
            props.setProperty(RSSEC_PRINCIPAL_NAME, p.getName());
        }
        return KeyManagementUtils.loadPrivateKey(keyStore, props, bus, cb);
    }

    public static KeyStore loadPersistKeyStore(Message m, Properties props) {
        KeyStore keyStore = (KeyStore)m.getExchange().get(props.get(RSSEC_KEY_STORE_FILE));
        if (keyStore == null) {
            keyStore = KeyManagementUtils.loadKeyStore(props, m.getExchange().getBus());
            m.getExchange().put((Object)((String)props.get(RSSEC_KEY_STORE_FILE)), (Object)keyStore);
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(Properties props, Bus bus) {
        String keyStoreType = props.getProperty(RSSEC_KEY_STORE_TYPE);
        String keyStoreLoc = props.getProperty(RSSEC_KEY_STORE_FILE);
        String keyStorePswd = props.getProperty(RSSEC_KEY_STORE_PSWD);
        try {
            InputStream is = ResourceUtils.getResourceStream((String)keyStoreLoc, (Bus)bus);
            return CryptoUtils.loadKeyStore((InputStream)is, (char[])keyStorePswd.toCharArray(), (String)keyStoreType);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static List<String> encodeX509CertificateChain(List<X509Certificate> chain) {
        ArrayList<String> encodedChain = new ArrayList<String>(chain.size());
        for (X509Certificate cert : chain) {
            try {
                encodedChain.add(CryptoUtils.encodeCertificate((Certificate)cert));
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        }
        return encodedChain;
    }

    public static List<X509Certificate> toX509CertificateChain(List<String> base64EncodedChain) {
        if (base64EncodedChain != null) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(base64EncodedChain.size());
            for (String encodedCert : base64EncodedChain) {
                try {
                    certs.add((X509Certificate)CryptoUtils.decodeCertificate((String)encodedCert));
                }
                catch (Exception ex) {
                    throw new SecurityException(ex);
                }
            }
            return certs;
        }
        return null;
    }
}

