/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.ByteBuffer;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cxf.common.util.crypto.HmacUtils;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.JweCompactProducer;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;

public class AesCbcHmacJweEncryption
extends AbstractJweEncryption {
    private static final Map<String, String> AES_HMAC_MAP = new HashMap<String, String>();
    private static final Map<String, Integer> AES_CEK_SIZE_MAP;

    public AesCbcHmacJweEncryption(String cekAlgoJwt, KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this(new JweHeaders(keyEncryptionAlgorithm.getAlgorithm(), cekAlgoJwt), null, null, keyEncryptionAlgorithm);
    }

    public AesCbcHmacJweEncryption(JweHeaders headers, KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this(headers, null, null, keyEncryptionAlgorithm);
    }

    public AesCbcHmacJweEncryption(JweHeaders headers, byte[] cek, byte[] iv, KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this(headers, cek, iv, keyEncryptionAlgorithm, null);
    }

    public AesCbcHmacJweEncryption(JweHeaders headers, byte[] cek, byte[] iv, KeyEncryptionAlgorithm keyEncryptionAlgorithm, JoseHeadersWriter writer) {
        super(headers, new AesCbcContentEncryptionAlgorithm(cek, iv, AesCbcHmacJweEncryption.validateCekAlgorithm(headers.getContentEncryptionAlgorithm())), keyEncryptionAlgorithm, writer);
    }

    @Override
    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return AesCbcHmacJweEncryption.doGetActualCek(theCek, algoJwt);
    }

    @Override
    protected int getCekSize(String algoJwt) {
        return AesCbcHmacJweEncryption.getFullCekKeySize(algoJwt) * 8;
    }

    protected static byte[] doGetActualCek(byte[] theCek, String algoJwt) {
        int size = AesCbcHmacJweEncryption.getFullCekKeySize(algoJwt) / 2;
        byte[] actualCek = new byte[size];
        System.arraycopy(theCek, size, actualCek, 0, size);
        return actualCek;
    }

    protected static int getFullCekKeySize(String algoJwt) {
        return AES_CEK_SIZE_MAP.get(algoJwt);
    }

    @Override
    protected JweCompactProducer getJweCompactProducer(AbstractJweEncryption.JweEncryptionInternal state, byte[] cipher) {
        MacState macState = this.getInitializedMacState(state);
        macState.mac.update(cipher);
        byte[] authTag = AesCbcHmacJweEncryption.signAndGetTag(macState);
        return new JweCompactProducer(macState.headersJson, state.jweContentEncryptionKey, state.theIv, cipher, authTag);
    }

    protected static byte[] signAndGetTag(MacState macState) {
        macState.mac.update(macState.al);
        byte[] sig = macState.mac.doFinal();
        int authTagLen = 16;
        byte[] authTag = new byte[authTagLen];
        System.arraycopy(sig, 0, authTag, 0, authTagLen);
        return authTag;
    }

    private MacState getInitializedMacState(AbstractJweEncryption.JweEncryptionInternal state) {
        String headersJson = this.getJwtHeadersWriter().headersToJson(state.theHeaders);
        return AesCbcHmacJweEncryption.getInitializedMacState(state.secretKey, state.theIv, state.theHeaders, headersJson);
    }

    protected static MacState getInitializedMacState(byte[] secretKey, byte[] theIv, JweHeaders theHeaders, String headersJson) {
        String algoJwt = theHeaders.getContentEncryptionAlgorithm();
        int size = AesCbcHmacJweEncryption.getFullCekKeySize(algoJwt) / 2;
        byte[] macKey = new byte[size];
        System.arraycopy(secretKey, 0, macKey, 0, size);
        String hmacAlgoJava = AES_HMAC_MAP.get(algoJwt);
        Mac mac = HmacUtils.getInitializedMac((byte[])macKey, (String)hmacAlgoJava, null);
        byte[] aad = JweHeaders.toCipherAdditionalAuthData(headersJson);
        ByteBuffer buf = ByteBuffer.allocate(8);
        byte[] al = buf.putInt(0).putInt(aad.length * 8).array();
        mac.update(aad);
        mac.update(theIv);
        MacState macState = new MacState();
        macState.mac = mac;
        MacState.access$102(macState, al);
        macState.headersJson = headersJson;
        return macState;
    }

    @Override
    protected AuthenticationTagProducer getAuthenticationTagProducer(AbstractJweEncryption.JweEncryptionInternal state) {
        final MacState macState = this.getInitializedMacState(state);
        return new AuthenticationTagProducer(){

            @Override
            public void update(byte[] cipher, int off, int len) {
                macState.mac.update(cipher, off, len);
            }

            @Override
            public byte[] getTag() {
                return AesCbcHmacJweEncryption.signAndGetTag(macState);
            }
        };
    }

    @Override
    protected byte[] getEncryptedContentEncryptionKey(byte[] theCek) {
        return this.getKeyEncryptionAlgo().getEncryptedContentEncryptionKey(this.getJweHeaders(), theCek);
    }

    private static String validateCekAlgorithm(String cekAlgo) {
        if (!Algorithm.isAesCbcHmac(cekAlgo)) {
            throw new SecurityException();
        }
        return cekAlgo;
    }

    static {
        AES_HMAC_MAP.put(Algorithm.A128CBC_HS256.getJwtName(), "HmacSHA256");
        AES_HMAC_MAP.put(Algorithm.A192CBC_HS384.getJwtName(), "HmacSHA384");
        AES_HMAC_MAP.put(Algorithm.A256CBC_HS512.getJwtName(), "HmacSHA512");
        AES_CEK_SIZE_MAP = new HashMap<String, Integer>();
        AES_CEK_SIZE_MAP.put(Algorithm.A128CBC_HS256.getJwtName(), 32);
        AES_CEK_SIZE_MAP.put(Algorithm.A192CBC_HS384.getJwtName(), 48);
        AES_CEK_SIZE_MAP.put(Algorithm.A256CBC_HS512.getJwtName(), 64);
    }

    protected static class MacState {
        protected Mac mac;
        private byte[] al;
        private String headersJson;

        protected MacState() {
        }

        static /* synthetic */ byte[] access$102(MacState x0, byte[] x1) {
            x0.al = x1;
            return x1;
        }
    }

    private static class AesCbcContentEncryptionAlgorithm
    extends AbstractContentEncryptionAlgorithm {
        public AesCbcContentEncryptionAlgorithm(byte[] cek, byte[] iv, String algo) {
            super(cek, iv, algo);
        }

        @Override
        public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
            return new IvParameterSpec(theIv);
        }

        @Override
        public byte[] getAdditionalAuthenticationData(String headersJson) {
            return null;
        }
    }
}

