/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class AesGcmContentDecryptionAlgorithm
extends AbstractContentEncryptionCipherProperties
implements ContentDecryptionAlgorithm {
    public AesGcmContentDecryptionAlgorithm(String supportedAlgo) {
        super(supportedAlgo);
    }

    @Override
    public byte[] getEncryptedSequence(JweHeaders headers, byte[] cipher, byte[] authTag) {
        String algo = headers.getContentEncryptionAlgorithm();
        if (!Algorithm.isAesGcm(algo) || !this.getAlgorithm().equals(algo)) {
            throw new SecurityException();
        }
        return JweCompactConsumer.getCipherWithAuthTag(cipher, authTag);
    }
}

