/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.rs.security.jose.jwe.AbstractJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class DirectKeyJweEncryption
extends AbstractJweEncryption {
    public DirectKeyJweEncryption(ContentEncryptionAlgorithm ceAlgo) {
        this(new JweHeaders(ceAlgo.getAlgorithm()), ceAlgo);
    }

    public DirectKeyJweEncryption(JweHeaders headers, ContentEncryptionAlgorithm ceAlgo) {
        super(headers, ceAlgo, new DirectKeyEncryptionAlgorithm());
    }

    @Override
    protected byte[] getProvidedContentEncryptionKey() {
        return DirectKeyJweEncryption.validateCek(super.getProvidedContentEncryptionKey());
    }

    private static byte[] validateCek(byte[] cek) {
        if (cek == null) {
            throw new NullPointerException("CEK must not be null");
        }
        return cek;
    }
}

