/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAOaepKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAOaepKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public final class JweUtils {
    private static final String JSON_WEB_ENCRYPTION_CEK_ALGO_PROP = "rs.security.jwe.content.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_KEY_ALGO_PROP = "rs.security.jwe.key.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP = "rs.security.jwe.zip.algorithm";
    private static final String RSSEC_ENCRYPTION_OUT_PROPS = "rs.security.encryption.out.properties";
    private static final String RSSEC_ENCRYPTION_IN_PROPS = "rs.security.encryption.in.properties";
    private static final String RSSEC_ENCRYPTION_PROPS = "rs.security.encryption.properties";

    private JweUtils() {
    }

    public static String encrypt(RSAPublicKey key, String keyAlgo, String contentAlgo, byte[] content) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, content, null);
    }

    public static String encrypt(RSAPublicKey key, String keyAlgo, String contentAlgo, byte[] content, String ct) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
    }

    public static String encrypt(SecretKey key, String keyAlgo, String contentAlgo, byte[] content) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, content, null);
    }

    public static String encrypt(SecretKey key, String keyAlgo, String contentAlgo, byte[] content, String ct) {
        if (keyAlgo != null) {
            KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, keyAlgo);
            return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
        }
        return JweUtils.encryptDirect(key, contentAlgo, content, ct);
    }

    public static String encrypt(JsonWebKey key, String contentAlgo, byte[] content, String ct) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(key);
        return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
    }

    public static String encryptDirect(SecretKey key, String contentAlgo, byte[] content) {
        return JweUtils.encryptDirect(key, contentAlgo, content, null);
    }

    public static String encryptDirect(SecretKey key, String contentAlgo, byte[] content, String ct) {
        DirectKeyJweEncryption jwe = JweUtils.getDirectKeyJweEncryption(key, contentAlgo);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    public static String encryptDirect(JsonWebKey key, byte[] content, String ct) {
        DirectKeyJweEncryption jwe = JweUtils.getDirectKeyJweEncryption(key);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    public static byte[] decrypt(RSAPrivateKey key, String keyAlgo, String contentAlgo, String content) {
        KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm(key, keyAlgo);
        return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
    }

    public static byte[] decrypt(SecretKey key, String keyAlgo, String contentAlgo, String content) {
        if (keyAlgo != null) {
            KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getSecretKeyDecryptionAlgorithm(key, keyAlgo);
            return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
        }
        return JweUtils.decryptDirect(key, contentAlgo, content);
    }

    public static byte[] decrypt(JsonWebKey key, String contentAlgo, String content) {
        KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(key);
        return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
    }

    public static byte[] decryptDirect(SecretKey key, String contentAlgo, String content) {
        DirectKeyJweDecryption jwe = JweUtils.getDirectKeyJweDecryption(key, contentAlgo);
        return jwe.decrypt(content).getContent();
    }

    public static byte[] decryptDirect(JsonWebKey key, String content) {
        DirectKeyJweDecryption jwe = JweUtils.getDirectKeyJweDecryption(key);
        return jwe.decrypt(content).getContent();
    }

    public static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyEncryptionAlgorithm(jwk, null);
    }

    public static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String keyEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        KeyEncryptionAlgorithm keyEncryptionProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(JwkUtils.toRSAPublicKey(jwk, true), keyEncryptionAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(JwkUtils.toSecretKey(jwk), keyEncryptionAlgo);
        }
        return keyEncryptionProvider;
    }

    public static KeyEncryptionAlgorithm getRSAKeyEncryptionAlgorithm(RSAPublicKey key, String algo) {
        return new RSAOaepKeyEncryptionAlgorithm(key, algo);
    }

    public static KeyEncryptionAlgorithm getSecretKeyEncryptionAlgorithm(SecretKey key, String algo) {
        if (Algorithm.isAesKeyWrap(algo)) {
            return new AesWrapKeyEncryptionAlgorithm(key, algo);
        }
        if (Algorithm.isAesGcmKeyWrap(algo)) {
            return new AesGcmWrapKeyEncryptionAlgorithm(key, algo);
        }
        return null;
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyDecryptionAlgorithm(jwk, null);
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String keyEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        KeyDecryptionAlgorithm keyDecryptionProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm(JwkUtils.toRSAPrivateKey(jwk), keyEncryptionAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            keyDecryptionProvider = JweUtils.getSecretKeyDecryptionAlgorithm(JwkUtils.toSecretKey(jwk), keyEncryptionAlgo);
        }
        return keyDecryptionProvider;
    }

    public static KeyDecryptionAlgorithm getRSAKeyDecryptionAlgorithm(RSAPrivateKey key, String algo) {
        return new RSAOaepKeyDecryptionAlgorithm(key, algo);
    }

    public static KeyDecryptionAlgorithm getSecretKeyDecryptionAlgorithm(SecretKey key, String algo) {
        if (Algorithm.isAesKeyWrap(algo)) {
            return new AesWrapKeyDecryptionAlgorithm(key, algo);
        }
        if (Algorithm.isAesGcmKeyWrap(algo)) {
            return new AesGcmWrapKeyDecryptionAlgorithm(key, algo);
        }
        return null;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getContentEncryptionAlgorithm(jwk, null);
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        ContentEncryptionAlgorithm contentEncryptionProvider = null;
        if ("oct".equals(jwk.getKeyType())) {
            return JweUtils.getContentEncryptionAlgorithm(JwkUtils.toSecretKey(jwk), ctEncryptionAlgo);
        }
        return contentEncryptionProvider;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(SecretKey key, String algorithm) {
        if (Algorithm.isAesGcm(algorithm)) {
            return new AesGcmContentEncryptionAlgorithm(key, null, algorithm);
        }
        return null;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(String algorithm) {
        if (Algorithm.isAesGcm(algorithm)) {
            return new AesGcmContentEncryptionAlgorithm(algorithm);
        }
        return null;
    }

    public static ContentDecryptionAlgorithm getContentDecryptionAlgorithm(String algorithm) {
        if (Algorithm.isAesGcm(algorithm)) {
            return new AesGcmContentDecryptionAlgorithm(algorithm);
        }
        return null;
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk) {
        return JweUtils.getContentDecryptionSecretKey(jwk, null);
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo;
        String string = ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        if ("oct".equals(jwk.getKeyType()) && Algorithm.isAesGcm(ctEncryptionAlgo)) {
            return JwkUtils.toSecretKey(jwk);
        }
        return null;
    }

    public static DirectKeyJweEncryption getDirectKeyJweEncryption(JsonWebKey key) {
        return new DirectKeyJweEncryption(JweUtils.getContentEncryptionAlgorithm(key, key.getAlgorithm()));
    }

    public static DirectKeyJweEncryption getDirectKeyJweEncryption(SecretKey key, String algorithm) {
        return new DirectKeyJweEncryption(JweUtils.getContentEncryptionAlgorithm(key, algorithm));
    }

    public static DirectKeyJweDecryption getDirectKeyJweDecryption(SecretKey key, String algorithm) {
        return new DirectKeyJweDecryption(key, JweUtils.getContentDecryptionAlgorithm(algorithm));
    }

    public static DirectKeyJweDecryption getDirectKeyJweDecryption(JsonWebKey key) {
        return new DirectKeyJweDecryption(JwkUtils.toSecretKey(key), JweUtils.getContentDecryptionAlgorithm(key.getAlgorithm()));
    }

    public static JweEncryptionProvider loadEncryptionProvider(boolean required) {
        String propLoc;
        Message m = JAXRSUtils.getCurrentMessage();
        if (m != null && (propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_OUT_PROPS, (String)RSSEC_ENCRYPTION_PROPS)) != null) {
            return JweUtils.loadEncryptionProvider(propLoc, m);
        }
        if (required) {
            throw new SecurityException();
        }
        return null;
    }

    public static JweEncryptionProvider loadEncryptionProvider(String propLoc, Message m) {
        KeyEncryptionAlgorithm keyEncryptionProvider = null;
        String keyEncryptionAlgo = null;
        Properties props = null;
        try {
            props = ResourceUtils.loadProperties((String)propLoc, (Bus)m.getExchange().getBus());
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
        String contentEncryptionAlgo = props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP);
        ContentEncryptionAlgorithm ctEncryptionProvider = null;
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "encrypt");
            keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(props, jwk.getAlgorithm());
            if ("direct".equals(keyEncryptionAlgo)) {
                contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(props, jwk.getAlgorithm());
                ctEncryptionProvider = JweUtils.getContentEncryptionAlgorithm(jwk, contentEncryptionAlgo);
            } else {
                keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(jwk, keyEncryptionAlgo);
            }
        } else {
            keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm((RSAPublicKey)KeyManagementUtils.loadPublicKey(m, props), JweUtils.getKeyEncryptionAlgo(props, keyEncryptionAlgo));
        }
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, ctEncryptionProvider, contentEncryptionAlgo, props.getProperty(JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP));
    }

    public static JweDecryptionProvider loadDecryptionProvider(boolean required) {
        String propLoc;
        Message m = JAXRSUtils.getCurrentMessage();
        if (m != null && (propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_IN_PROPS, (String)RSSEC_ENCRYPTION_PROPS)) != null) {
            return JweUtils.loadDecryptionProvider(propLoc, m);
        }
        if (required) {
            throw new SecurityException();
        }
        return null;
    }

    public static JweDecryptionProvider loadDecryptionProvider(String propLoc, Message m) {
        KeyDecryptionAlgorithm keyDecryptionProvider = null;
        Properties props = null;
        try {
            props = ResourceUtils.loadProperties((String)propLoc, (Bus)m.getExchange().getBus());
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
        String contentEncryptionAlgo = props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP);
        SecretKey ctDecryptionKey = null;
        String keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(props, null);
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "decrypt");
            keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(props, jwk.getAlgorithm());
            if ("direct".equals(keyEncryptionAlgo)) {
                contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(props, contentEncryptionAlgo);
                ctDecryptionKey = JweUtils.getContentDecryptionSecretKey(jwk, contentEncryptionAlgo);
            } else {
                keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(jwk, keyEncryptionAlgo);
            }
        } else {
            keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm((RSAPrivateKey)KeyManagementUtils.loadPrivateKey(m, props, "rs.security.decryption.key.password.provider"), keyEncryptionAlgo);
        }
        return JweUtils.createJweDecryptionProvider(keyDecryptionProvider, ctDecryptionKey, contentEncryptionAlgo);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(RSAPublicKey key, String keyAlgo, String contentEncryptionAlgo, String compression) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(RSAPublicKey key, JweHeaders headers) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(key, headers.getKeyEncryptionAlgorithm());
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(SecretKey key, String keyAlgo, String contentEncryptionAlgo, String compression) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(SecretKey key, JweHeaders headers) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, headers.getKeyEncryptionAlgorithm());
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(JsonWebKey key, String contentEncryptionAlgo, String compression) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(key);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(JsonWebKey key, JweHeaders headers) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(key);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionAlgorithm keyEncryptionProvider, String contentEncryptionAlgo, String compression) {
        JweHeaders headers = JweUtils.prepareJweHeaders(keyEncryptionProvider != null ? keyEncryptionProvider.getAlgorithm() : null, contentEncryptionAlgo, compression);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionAlgorithm keyEncryptionProvider, JweHeaders headers) {
        String contentEncryptionAlgo = headers.getContentEncryptionAlgorithm();
        if (Algorithm.isAesCbcHmac(contentEncryptionAlgo)) {
            return new AesCbcHmacJweEncryption(headers, keyEncryptionProvider);
        }
        return new WrappedKeyJweEncryption(headers, keyEncryptionProvider, JweUtils.getContentEncryptionAlgorithm(contentEncryptionAlgo));
    }

    public static JweDecryptionProvider createJweDecryptionProvider(RSAPrivateKey key, String keyAlgo, String contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getRSAKeyDecryptionAlgorithm(key, keyAlgo), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(SecretKey key, String keyAlgo, String contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getSecretKeyDecryptionAlgorithm(key, keyAlgo), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(JsonWebKey key, String contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getKeyDecryptionAlgorithm(key), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(KeyDecryptionAlgorithm keyDecryptionProvider, String contentDecryptionAlgo) {
        if (Algorithm.isAesCbcHmac(contentDecryptionAlgo)) {
            return new AesCbcHmacJweDecryption(keyDecryptionProvider, contentDecryptionAlgo);
        }
        return new WrappedKeyJweDecryption(keyDecryptionProvider, JweUtils.getContentDecryptionAlgorithm(contentDecryptionAlgo));
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        return JoseUtils.validateCriticalHeaders(headers);
    }

    private static JweHeaders prepareJweHeaders(String keyEncryptionAlgo, String contentEncryptionAlgo, String compression) {
        JweHeaders headers = new JweHeaders();
        if (keyEncryptionAlgo != null) {
            headers.setAlgorithm(keyEncryptionAlgo);
            headers.setContentEncryptionAlgorithm(contentEncryptionAlgo);
            if (compression != null) {
                headers.setZipAlgorithm(compression);
            }
        }
        return headers;
    }

    private static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionAlgorithm keyEncryptionProvider, ContentEncryptionAlgorithm ctEncryptionProvider, String contentEncryptionAlgo, String compression) {
        if (keyEncryptionProvider == null && ctEncryptionProvider == null) {
            throw new SecurityException();
        }
        JweHeaders headers = JweUtils.prepareJweHeaders(keyEncryptionProvider != null ? keyEncryptionProvider.getAlgorithm() : null, contentEncryptionAlgo, compression);
        if (keyEncryptionProvider != null) {
            return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
        }
        return new DirectKeyJweEncryption(headers, ctEncryptionProvider);
    }

    private static JweDecryptionProvider createJweDecryptionProvider(KeyDecryptionAlgorithm keyDecryptionProvider, SecretKey ctDecryptionKey, String contentDecryptionAlgo) {
        if (keyDecryptionProvider == null && ctDecryptionKey == null) {
            throw new SecurityException();
        }
        if (keyDecryptionProvider != null) {
            return JweUtils.createJweDecryptionProvider(keyDecryptionProvider, contentDecryptionAlgo);
        }
        return JweUtils.getDirectKeyJweDecryption(ctDecryptionKey, contentDecryptionAlgo);
    }

    private static String getKeyEncryptionAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_ENCRYPTION_KEY_ALGO_PROP) : algo;
    }

    private static String getContentEncryptionAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP) : algo;
    }

    private static String encrypt(KeyEncryptionAlgorithm keyEncryptionProvider, String contentAlgo, byte[] content, String ct) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentAlgo, null);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    private static byte[] decrypt(KeyDecryptionAlgorithm keyDecryptionProvider, String contentAlgo, String content) {
        JweDecryptionProvider jwe = JweUtils.createJweDecryptionProvider(keyDecryptionProvider, contentAlgo);
        return jwe.decrypt(content).getContent();
    }

    private static JweHeaders toJweHeaders(String ct) {
        return new JweHeaders(Collections.singletonMap("cty", ct));
    }
}

