/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

public abstract class AbstractJwsSignatureProvider
implements JwsSignatureProvider {
    private String algorithm;

    protected AbstractJwsSignatureProvider(String algo) {
        this.algorithm = algo;
    }

    protected JoseHeaders prepareHeaders(JoseHeaders headers) {
        String algo;
        if (headers == null) {
            headers = new JoseHeaders();
        }
        if ((algo = headers.getAlgorithm()) != null) {
            this.checkAlgorithm(algo);
        } else {
            this.checkAlgorithm(this.algorithm);
            headers.setAlgorithm(this.algorithm);
        }
        return headers;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] sign(JoseHeaders headers, byte[] content) {
        JwsSignature sig = this.createJwsSignature(headers);
        sig.update(content, 0, content.length);
        return sig.sign();
    }

    @Override
    public JwsSignature createJwsSignature(JoseHeaders headers) {
        return this.doCreateJwsSignature(this.prepareHeaders(headers));
    }

    protected abstract JwsSignature doCreateJwsSignature(JoseHeaders var1);

    protected void checkAlgorithm(String algo) {
        if (algo == null) {
            throw new SecurityException();
        }
    }
}

