/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.provider.json.JsonMapObject;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsJsonUnprotectedHeader;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonConsumer {
    private String jwsSignedDocument;
    private String encodedJwsPayload;
    private List<JwsJsonSignatureEntry> signatureEntries;

    public JwsJsonConsumer(String jwsSignedDocument) {
        this.jwsSignedDocument = jwsSignedDocument;
        this.prepare();
    }

    private void prepare() {
        JsonMapObject jsonObject = new JsonMapObject();
        new JsonMapObjectReaderWriter().fromJson(jsonObject, this.jwsSignedDocument);
        this.encodedJwsPayload = (String)jsonObject.asMap().get("payload");
        if (this.encodedJwsPayload == null) {
            throw new SecurityException("Invalid JWS JSON sequence: no payload is available");
        }
        List signatureArray = CastUtils.cast((List)((List)jsonObject.asMap().get("signatures")));
        this.signatureEntries = new ArrayList<JwsJsonSignatureEntry>(signatureArray.size());
        for (Map signatureEntry : signatureArray) {
            String protectedHeader = (String)signatureEntry.get("protected");
            Map header = CastUtils.cast((Map)((Map)signatureEntry.get("header")));
            String signature = (String)signatureEntry.get("signature");
            JwsJsonSignatureEntry signatureObject = new JwsJsonSignatureEntry(this.encodedJwsPayload, protectedHeader, signature, header != null ? new JwsJsonUnprotectedHeader(header) : null);
            this.signatureEntries.add(signatureObject);
        }
        if (this.signatureEntries.isEmpty()) {
            throw new SecurityException("Invalid JWS JSON sequence: no signatures are available");
        }
    }

    public String getSignedDocument() {
        return this.jwsSignedDocument;
    }

    public String getEncodedJwsPayload() {
        return this.encodedJwsPayload;
    }

    public String getDecodedJwsPayload() {
        return JoseUtils.decodeToString(this.encodedJwsPayload);
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.getDecodedJwsPayload());
    }

    public List<JwsJsonSignatureEntry> getSignatureEntries() {
        return Collections.unmodifiableList(this.signatureEntries);
    }

    public MultivaluedMap<String, JwsJsonSignatureEntry> getSignatureEntryMap() {
        return JwsUtils.getJwsJsonSignatureMap(this.signatureEntries);
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        List theSignatureEntries = (List)this.getSignatureEntryMap().get((Object)validator.getAlgorithm());
        if (theSignatureEntries != null) {
            for (JwsJsonSignatureEntry signatureEntry : theSignatureEntries) {
                if (!signatureEntry.verifySignatureWith(validator)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verifySignatureWith(RSAPublicKey key, String algo) {
        return this.verifySignatureWith(JwsUtils.getRSAKeySignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(byte[] key, String algo) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(List<JwsSignatureVerifier> validators) {
        try {
            this.verifyAndGetNonValidated(validators);
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public List<JwsJsonSignatureEntry> verifyAndGetNonValidated(List<JwsSignatureVerifier> validators) {
        if (validators.size() > this.signatureEntries.size()) {
            throw new SecurityException("Too many signature validators");
        }
        LinkedList<JwsJsonSignatureEntry> validatedSignatures = new LinkedList<JwsJsonSignatureEntry>();
        for (JwsSignatureVerifier validator : validators) {
            boolean validated = false;
            List theSignatureEntries = (List)this.getSignatureEntryMap().get((Object)validator.getAlgorithm());
            if (theSignatureEntries != null) {
                for (JwsJsonSignatureEntry sigEntry : theSignatureEntries) {
                    if (!sigEntry.verifySignatureWith(validator)) continue;
                    validatedSignatures.add(sigEntry);
                    validated = true;
                    break;
                }
            }
            if (validated) continue;
            throw new SecurityException();
        }
        if (validatedSignatures.isEmpty()) {
            throw new SecurityException();
        }
        LinkedList<JwsJsonSignatureEntry> nonValidatedSignatures = new LinkedList<JwsJsonSignatureEntry>();
        for (JwsJsonSignatureEntry sigEntry : this.signatureEntries) {
            if (validatedSignatures.contains(sigEntry)) continue;
            nonValidatedSignatures.add(sigEntry);
        }
        return nonValidatedSignatures;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public JwsJsonProducer toProducer() {
        return new JwsJsonProducer(this.getDecodedJwsPayload(), this.signatureEntries);
    }
}

