/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.CodeVerifierTransformer;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class AuthorizationCodeGrantHandler
extends AbstractGrantHandler {
    private CodeVerifierTransformer codeVerifierTransformer;

    public AuthorizationCodeGrantHandler() {
        super("authorization_code");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String clientCodeChallenge;
        String codeValue = (String)params.getFirst((Object)"code");
        ServerAuthorizationCodeGrant grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).removeCodeGrant(codeValue);
        if (grant == null) {
            return null;
        }
        if (OAuthUtils.isExpired(grant.getIssuedAt(), grant.getExpiresIn())) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (!grant.getClient().getClientId().equals(client.getClientId())) {
            throw new OAuthServiceException("invalid_grant");
        }
        String expectedRedirectUri = grant.getRedirectUri();
        String providedRedirectUri = (String)params.getFirst((Object)"redirect_uri");
        if (providedRedirectUri != null ? expectedRedirectUri == null || !providedRedirectUri.equals(expectedRedirectUri) : expectedRedirectUri == null && !this.isCanSupportPublicClients() || expectedRedirectUri != null && (client.getRedirectUris().size() != 1 || !client.getRedirectUris().contains(expectedRedirectUri))) {
            throw new OAuthServiceException("invalid_request");
        }
        String clientCodeVerifier = grant.getClientCodeVerifier();
        if (clientCodeVerifier != null && !this.compareCodeVerifierWithChallenge(clientCodeVerifier, clientCodeChallenge = (String)params.getFirst((Object)"code_verifier"))) {
            throw new OAuthServiceException("invalid_grant");
        }
        return this.doCreateAccessToken(client, grant.getSubject(), grant.getApprovedScopes(), grant.getAudience());
    }

    private boolean compareCodeVerifierWithChallenge(String clientCodeVerifier, String clientCodeChallenge) {
        if (clientCodeChallenge == null) {
            return false;
        }
        String transformedCodeVerifier = this.codeVerifierTransformer == null ? clientCodeVerifier : this.codeVerifierTransformer.transformCodeVerifier(clientCodeVerifier);
        return clientCodeChallenge.equals(transformedCodeVerifier);
    }

    public void setCodeVerifierTransformer(CodeVerifierTransformer codeVerifier) {
        this.codeVerifierTransformer = codeVerifier;
    }
}

