/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeRequestFilter;

public class JwtRequestCodeFilter
implements AuthorizationCodeRequestFilter {
    private static final String REQUEST_PARAM = "request";
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;
    private String issuer;

    @Override
    public MultivaluedMap<String, String> process(MultivaluedMap<String, String> params, UserSubject endUser, Client client) {
        String requestToken = (String)params.getFirst((Object)REQUEST_PARAM);
        if (requestToken != null) {
            String iss;
            JwsSignatureVerifier theSigVerifier;
            JwsJwtCompactConsumer consumer;
            JweDecryptionProvider theJweDecryptor = this.getInitializedDecryptionProvider();
            if (theJweDecryptor != null) {
                requestToken = theJweDecryptor.decrypt(requestToken).getContentText();
            }
            if (!(consumer = new JwsJwtCompactConsumer(requestToken)).verifySignatureWith(theSigVerifier = this.getInitializedSigVerifier())) {
                throw new SecurityException("Invalid Signature");
            }
            JwtClaims claims = consumer.getJwtClaims();
            String string = iss = this.issuer != null ? this.issuer : client.getClientId();
            if (!iss.equals(claims.getIssuer()) || claims.getClaim("client_id") != null && claims.getStringProperty("client_id").equals(client.getClientId())) {
                throw new SecurityException();
            }
            MetadataMap newParams = new MetadataMap();
            Map claimsMap = claims.asMap();
            for (Map.Entry entry : claimsMap.entrySet()) {
                newParams.putSingle(entry.getKey(), (Object)entry.getValue().toString());
            }
            return newParams;
        }
        return params;
    }

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public void setJweVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider() {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider((boolean)false);
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        return JwsUtils.loadSignatureVerifier((boolean)true);
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
}

