/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;

public class JwtRequestCodeGrant
extends AuthorizationCodeGrant {
    private static final long serialVersionUID = -3738825769770411453L;
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;
    private String issuer;

    public JwtRequestCodeGrant() {
    }

    public JwtRequestCodeGrant(String issuer) {
        this.issuer = issuer;
    }

    public JwtRequestCodeGrant(String code, String issuer) {
        super(code);
        this.issuer = issuer;
    }

    public JwtRequestCodeGrant(String code, URI uri, String issuer) {
        super(code, uri);
        this.issuer = issuer;
    }

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider(JoseHeaders headers) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider((boolean)true);
        headers.setAlgorithm(theSigProvider.getAlgorithm());
        return theSigProvider;
    }

    @Override
    public MultivaluedMap<String, String> toMap() {
        String request = this.getRequest();
        MetadataMap newMap = new MetadataMap();
        newMap.putSingle((Object)"request", (Object)request);
        return newMap;
    }

    public String getRequest() {
        MultivaluedMap<String, String> map = super.toMap();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(this.issuer);
        for (String key : map.keySet()) {
            claims.setClaim(key, map.getFirst((Object)key));
        }
        JwsJwtCompactProducer producer = new JwsJwtCompactProducer(claims);
        JoseHeaders headers = new JoseHeaders();
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider(headers);
        String request = producer.signWith(theSigProvider);
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider();
        if (theEncryptionProvider != null) {
            request = theEncryptionProvider.encrypt(StringUtils.toBytesUTF8((String)request), null);
        }
        return request;
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider() {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider((boolean)false);
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
}

