/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenResponseFilter;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="/authorize-implicit")
public class ImplicitGrantService
extends RedirectionBasedGrantService {
    private boolean reportClientId;
    private List<AccessTokenResponseFilter> responseHandlers = new LinkedList<AccessTokenResponseFilter>();

    public ImplicitGrantService() {
        super("token", "implicit");
    }

    @Override
    protected Response createGrant(MultivaluedMap<String, String> params, Client client, String redirectUri, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAccessToken token = null;
        if (preAuthorizedToken == null) {
            AccessTokenRegistration reg = new AccessTokenRegistration();
            reg.setClient(client);
            reg.setGrantType("implicit");
            reg.setSubject(userSubject);
            reg.setRequestedScope(requestedScope);
            reg.setApprovedScope(approvedScope);
            reg.setAudience((String)params.getFirst((Object)"audience"));
            token = this.getDataProvider().createAccessToken(reg);
        } else {
            token = preAuthorizedToken;
        }
        ClientAccessToken clientToken = OAuthUtils.toClientAccessToken(token, this.isWriteOptionalParameters());
        this.processClientAccessToken(clientToken, token);
        StringBuilder sb = this.getUriWithFragment(redirectUri);
        sb.append("access_token").append("=").append(clientToken.getTokenKey());
        String state = (String)params.getFirst((Object)"state");
        if (state != null) {
            sb.append("&");
            sb.append("state").append("=").append(state);
        }
        sb.append("&").append("token_type").append("=").append(clientToken.getTokenType());
        if (this.isWriteOptionalParameters()) {
            sb.append("&").append("expires_in").append("=").append(clientToken.getExpiresIn());
            if (!StringUtils.isEmpty((String)clientToken.getApprovedScope())) {
                sb.append("&").append("scope").append("=").append(HttpUtils.queryEncode((String)clientToken.getApprovedScope()));
            }
            for (Map.Entry<String, String> entry : clientToken.getParameters().entrySet()) {
                sb.append("&").append(entry.getKey()).append("=").append(HttpUtils.queryEncode((String)entry.getValue()));
            }
        }
        if (this.reportClientId) {
            sb.append("&").append("client_id").append("=").append(client.getClientId());
        }
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    protected void processClientAccessToken(ClientAccessToken clientToken, ServerAccessToken serverToken) {
        for (AccessTokenResponseFilter filter : this.responseHandlers) {
            filter.process(clientToken, serverToken);
        }
    }

    @Override
    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        StringBuilder sb = this.getUriWithFragment(redirectUri);
        sb.append("error").append("=").append(error);
        String state = (String)params.getFirst((Object)"state");
        if (state != null) {
            sb.append("&");
            sb.append("state").append("=").append(state);
        }
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    private StringBuilder getUriWithFragment(String redirectUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(redirectUri);
        sb.append("#");
        return sb;
    }

    public void setReportClientId(boolean reportClientId) {
        this.reportClientId = reportClientId;
    }

    public void setResponseFilters(List<AccessTokenResponseFilter> handlers) {
        this.responseHandlers = handlers;
    }

    public void setResponseFilter(AccessTokenResponseFilter responseHandler) {
        this.responseHandlers.add(responseHandler);
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return true;
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return false;
    }
}

