/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.continuations;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.message.Message;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class JettyContinuationWrapper
implements org.apache.cxf.continuations.Continuation,
ContinuationListener {
    volatile boolean isNew;
    volatile boolean isResumed;
    volatile boolean isPending;
    volatile long pendingTimeout;
    volatile Object obj;
    private Message message;
    private Continuation continuation;
    private ContinuationCallback callback;

    public JettyContinuationWrapper(HttpServletRequest request, HttpServletResponse resp, Message m) {
        this.continuation = ContinuationSupport.getContinuation((ServletRequest)request);
        this.message = m;
        boolean bl = this.isNew = request.getAttribute("cxf.continuation.message") == null;
        if (this.isNew) {
            request.setAttribute("cxf.continuation.message", (Object)this.message.getExchange().getInMessage());
            this.continuation.addContinuationListener((ContinuationListener)this);
            this.callback = (ContinuationCallback)this.message.getExchange().get(ContinuationCallback.class);
        }
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object userObject) {
        this.obj = userObject;
    }

    public void resume() {
        this.isResumed = true;
        this.isPending = false;
        this.continuation.resume();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public boolean isResumed() {
        return this.isResumed;
    }

    public boolean isExpired() {
        return this.continuation.isExpired();
    }

    public void reset() {
        try {
            this.continuation.complete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.obj = null;
        this.pendingTimeout = 0L;
    }

    public boolean suspend(long timeout) {
        this.pendingTimeout = this.isPending && timeout != 0L ? (this.pendingTimeout += this.pendingTimeout + timeout) : timeout;
        this.isNew = false;
        this.message.getExchange().getInMessage().getInterceptorChain().suspend();
        this.continuation.setTimeout(this.pendingTimeout);
        if (!this.isPending) {
            this.continuation.suspend();
            this.isPending = true;
        }
        return true;
    }

    protected Message getMessage() {
        Message m = this.message;
        if (m != null && m.getExchange().getInMessage() != null) {
            m = m.getExchange().getInMessage();
        }
        return m;
    }

    public void onComplete(Continuation cont) {
        this.getMessage().remove((Object)"cxf.continuation.message");
        this.isPending = false;
        this.pendingTimeout = 0L;
        this.isResumed = false;
        if (this.callback != null) {
            this.callback.onComplete();
        }
    }

    public void onTimeout(Continuation cont) {
        this.isPending = false;
        this.pendingTimeout = 0L;
        this.isResumed = true;
    }
}

