/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientHandler;
import org.apache.cxf.transport.https.SSLUtils;

public class NettyHttpClientPipelineFactory
extends ChannelInitializer<Channel> {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpClientPipelineFactory.class);
    private final TLSClientParameters tlsClientParameters;

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters) {
        this.tlsClientParameters = clientParameters;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("client", (ChannelHandler)new NettyHttpClientHandler());
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (this.tlsClientParameters != null) {
            SSLEngine sslEngine = SSLUtils.createClientSSLEngine((TLSClientParameters)this.tlsClientParameters);
            return new SslHandler(sslEngine);
        }
        return null;
    }
}

