/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.task.paramparser;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.spi.enums.CommandType;
import org.apache.dolphinscheduler.spi.enums.DataType;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.Direct;
import org.apache.dolphinscheduler.spi.task.Property;
import org.apache.dolphinscheduler.spi.task.paramparser.BusinessTimeUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class ParamUtils {
    public static Map<String, Property> convert(TaskRequest taskExecutionContext, AbstractParameters parameters) {
        Preconditions.checkNotNull((Object)taskExecutionContext);
        Preconditions.checkNotNull((Object)parameters);
        Map<String, Property> globalParams = ParamUtils.getUserDefParamsMap(taskExecutionContext.getDefinedParams());
        Map<String, String> globalParamsMap = taskExecutionContext.getDefinedParams();
        CommandType commandType = CommandType.of(taskExecutionContext.getCmdTypeIfComplement());
        Date scheduleTime = taskExecutionContext.getScheduleTime();
        Map<String, Property> localParams = parameters.getLocalParametersMap();
        Map<String, Property> varParams = parameters.getVarPoolMap();
        if (globalParams == null && localParams == null) {
            return null;
        }
        Map<String, String> params = BusinessTimeUtils.getBusinessTime(commandType, scheduleTime);
        if (globalParamsMap != null) {
            params.putAll(globalParamsMap);
        }
        if (StringUtils.isNotBlank(taskExecutionContext.getExecutePath())) {
            params.put("system.task.execute.path", taskExecutionContext.getExecutePath());
        }
        params.put("system.task.instance.id", Integer.toString(taskExecutionContext.getTaskInstanceId()));
        if (globalParams != null && localParams != null) {
            globalParams.putAll(localParams);
        } else if (globalParams == null && localParams != null) {
            globalParams = localParams;
        }
        if (varParams != null) {
            varParams.putAll(globalParams);
            globalParams = varParams;
        }
        for (Map.Entry<String, Property> en : globalParams.entrySet()) {
            Property property = en.getValue();
            if (!StringUtils.isNotEmpty(property.getValue()) || !property.getValue().startsWith("$")) continue;
            String val = property.getValue();
            val = ParameterUtils.convertParameterPlaceholders(val, params);
            property.setValue(val);
        }
        return globalParams;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        if (paramsMap == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    public static Map<String, Property> getUserDefParamsMap(Map<String, String> definedParams) {
        if (definedParams != null) {
            HashMap<String, Property> userDefParamsMaps = new HashMap<String, Property>();
            for (Map.Entry<String, String> en : definedParams.entrySet()) {
                Property property = new Property(en.getKey(), Direct.IN, DataType.VARCHAR, en.getValue());
                userDefParamsMaps.put(property.getProp(), property);
            }
            return userDefParamsMaps;
        }
        return null;
    }
}

