/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcStatus;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class ShortestResponseLoadBalance
extends AbstractLoadBalance
implements ScopeModelAware {
    public static final String NAME = "shortestresponse";
    private int slidePeriod = 30000;
    private ConcurrentMap<RpcStatus, SlideWindowData> methodMap = new ConcurrentHashMap<RpcStatus, SlideWindowData>();
    private AtomicBoolean onResetSlideWindow = new AtomicBoolean(false);
    private volatile long lastUpdateTime = System.currentTimeMillis();
    private ExecutorService executorService;

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.slidePeriod = applicationModel.getModelEnvironment().getConfiguration().getInt("shortestResponseSlidePeriod", 30000);
        this.executorService = applicationModel.getApplicationExecutorRepository().getSharedExecutor();
    }

    @Override
    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        int length = invokers.size();
        long shortestResponse = Long.MAX_VALUE;
        int shortestCount = 0;
        int[] shortestIndexes = new int[length];
        int[] weights = new int[length];
        int totalWeight = 0;
        int firstWeight = 0;
        boolean sameWeight = true;
        for (int i = 0; i < length; ++i) {
            int afterWarmup;
            Invoker<T> invoker = invokers.get(i);
            RpcStatus rpcStatus = RpcStatus.getStatus((URL)invoker.getUrl(), (String)invocation.getMethodName());
            SlideWindowData slideWindowData = this.methodMap.computeIfAbsent(rpcStatus, SlideWindowData::new);
            long estimateResponse = slideWindowData.getEstimateResponse();
            weights[i] = afterWarmup = this.getWeight(invoker, invocation);
            if (estimateResponse < shortestResponse) {
                shortestResponse = estimateResponse;
                shortestCount = 1;
                shortestIndexes[0] = i;
                totalWeight = afterWarmup;
                firstWeight = afterWarmup;
                sameWeight = true;
                continue;
            }
            if (estimateResponse != shortestResponse) continue;
            shortestIndexes[shortestCount++] = i;
            totalWeight += afterWarmup;
            if (!sameWeight || i <= 0 || afterWarmup == firstWeight) continue;
            sameWeight = false;
        }
        if (System.currentTimeMillis() - this.lastUpdateTime > (long)this.slidePeriod && this.onResetSlideWindow.compareAndSet(false, true)) {
            this.executorService.execute(() -> {
                this.methodMap.values().forEach(SlideWindowData::reset);
                this.lastUpdateTime = System.currentTimeMillis();
                this.onResetSlideWindow.set(false);
            });
        }
        if (shortestCount == 1) {
            return invokers.get(shortestIndexes[0]);
        }
        if (!sameWeight && totalWeight > 0) {
            int offsetWeight = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < shortestCount; ++i) {
                int shortestIndex = shortestIndexes[i];
                if ((offsetWeight -= weights[shortestIndex]) >= 0) continue;
                return invokers.get(shortestIndex);
            }
        }
        return invokers.get(shortestIndexes[ThreadLocalRandom.current().nextInt(shortestCount)]);
    }

    protected static class SlideWindowData {
        private long succeededOffset;
        private long succeededElapsedOffset;
        private RpcStatus rpcStatus;

        public SlideWindowData(RpcStatus rpcStatus) {
            this.rpcStatus = rpcStatus;
            this.succeededOffset = 0L;
            this.succeededElapsedOffset = 0L;
        }

        public void reset() {
            this.succeededOffset = this.rpcStatus.getSucceeded();
            this.succeededElapsedOffset = this.rpcStatus.getSucceededElapsed();
        }

        private long getSucceededAverageElapsed() {
            long succeed = this.rpcStatus.getSucceeded() - this.succeededOffset;
            if (succeed == 0L) {
                return 0L;
            }
            return (this.rpcStatus.getSucceededElapsed() - this.succeededElapsedOffset) / succeed;
        }

        public long getEstimateResponse() {
            int active = this.rpcStatus.getActive() + 1;
            return this.getSucceededAverageElapsed() * (long)active;
        }
    }
}

