/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mock;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterResult;

public class MockInvokersSelector<T>
extends AbstractStateRouter<T> {
    public static final String NAME = "MOCK_ROUTER";
    private static final int MOCK_INVOKERS_DEFAULT_PRIORITY = -100;
    private volatile BitList<Invoker<T>> normalInvokers = BitList.emptyList();
    private volatile BitList<Invoker<T>> mockedInvokers = BitList.emptyList();

    public MockInvokersSelector(URL url) {
        super(url);
        this.setPriority(-100);
    }

    @Override
    public StateRouterResult<Invoker<T>> route(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            return new StateRouterResult<Invoker<T>>(invokers, needToPrintMessage ? "Empty invokers. Directly return." : null);
        }
        if (invocation.getObjectAttachments() == null) {
            return new StateRouterResult<Invoker<T>>(invokers.and(this.normalInvokers), needToPrintMessage ? "ObjectAttachments from invocation are null. Return normal Invokers." : null);
        }
        String value = (String)invocation.getObjectAttachments().get("invocation.need.mock");
        if (value == null) {
            return new StateRouterResult<Invoker<T>>(invokers.and(this.normalInvokers), needToPrintMessage ? "invocation.need.mock not set. Return normal Invokers." : null);
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return new StateRouterResult<Invoker<T>>(invokers.and(this.mockedInvokers), needToPrintMessage ? "invocation.need.mock is true. Return mocked Invokers." : null);
        }
        return new StateRouterResult<Invoker<T>>(invokers, needToPrintMessage ? "Directly Return. Reason: invocation.need.mock is set but not match true" : null);
    }

    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        this.cacheMockedInvokers(invokers);
        this.cacheNormalInvokers(invokers);
    }

    private void cacheMockedInvokers(BitList<Invoker<T>> invokers) {
        Object clonedInvokers = invokers.clone();
        clonedInvokers.removeIf(invoker -> !invoker.getUrl().getProtocol().equals("mock"));
        this.mockedInvokers = clonedInvokers;
    }

    private void cacheNormalInvokers(BitList<Invoker<T>> invokers) {
        Object clonedInvokers = invokers.clone();
        clonedInvokers.removeIf(invoker -> invoker.getUrl().getProtocol().equals("mock"));
        this.normalInvokers = clonedInvokers;
    }
}

