/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class BroadcastClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastClusterInvoker.class);
    private static final String BROADCAST_FAIL_PERCENT_KEY = "broadcast.fail.percent";
    private static final int MAX_BROADCAST_FAIL_PERCENT = 100;
    private static final int MIN_BROADCAST_FAIL_PERCENT = 0;

    public BroadcastClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        this.checkInvokers(invokers, invocation);
        RpcContext.getServiceContext().setInvokers(invokers);
        RpcException exception = null;
        Result result = null;
        URL url = this.getUrl();
        int broadcastFailPercent = url.getParameter(BROADCAST_FAIL_PERCENT_KEY, 100);
        if (broadcastFailPercent < 0 || broadcastFailPercent > 100) {
            logger.info(String.format("The value corresponding to the broadcast.fail.percent parameter must be between 0 and 100. The current setting is %s, which is reset to 100.", broadcastFailPercent));
            broadcastFailPercent = 100;
        }
        int failThresholdIndex = invokers.size() * broadcastFailPercent / 100;
        int failIndex = 0;
        for (Invoker<T> invoker : invokers) {
            try {
                Throwable resultException;
                RpcInvocation subInvocation = new RpcInvocation(invocation, invoker);
                subInvocation.setAttachment("async", "true");
                result = this.invokeWithContext(invoker, (Invocation)subInvocation);
                if (null == result || !result.hasException() || null == (resultException = result.getException())) continue;
                exception = this.getRpcException(result.getException());
                logger.warn(exception.getMessage(), (Throwable)exception);
                if (++failIndex != failThresholdIndex) continue;
            }
            catch (Throwable e) {
                exception = this.getRpcException(e);
                logger.warn(exception.getMessage(), (Throwable)exception);
                if (++failIndex != failThresholdIndex) continue;
            }
            break;
        }
        if (exception != null) {
            if (failIndex == failThresholdIndex) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("The number of BroadcastCluster call failures has reached the threshold %s", failThresholdIndex));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format("The number of BroadcastCluster call failures has not reached the threshold %s, fail size is %s", failThresholdIndex, failIndex));
            }
            throw exception;
        }
        return result;
    }

    private RpcException getRpcException(Throwable throwable) {
        RpcException rpcException = throwable instanceof RpcException ? (RpcException)throwable : new RpcException(throwable.getMessage(), throwable);
        return rpcException;
    }
}

