/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvocationProfilerUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.support.RpcUtils;

public abstract class AbstractClusterInvoker<T>
implements ClusterInvoker<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractClusterInvoker.class);
    protected Directory<T> directory;
    protected boolean availableCheck;
    private volatile int reselectCount = 10;
    private volatile boolean enableConnectivityValidation = true;
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private volatile Invoker<T> stickyInvoker = null;

    public AbstractClusterInvoker() {
    }

    public AbstractClusterInvoker(Directory<T> directory) {
        this(directory, directory.getUrl());
    }

    public AbstractClusterInvoker(Directory<T> directory, URL url) {
        if (directory == null) {
            throw new IllegalArgumentException("service directory == null");
        }
        this.directory = directory;
        this.availableCheck = url.getParameter("cluster.availablecheck", true);
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration((ScopeModel)url.getOrDefaultModuleModel());
        this.reselectCount = configuration.getInt("dubbo.reselect.count", 10);
        this.enableConnectivityValidation = configuration.getBoolean("dubbo.connectivity.validation", true);
    }

    public Class<T> getInterface() {
        return this.getDirectory().getInterface();
    }

    public URL getUrl() {
        return this.getDirectory().getConsumerUrl();
    }

    @Override
    public URL getRegistryUrl() {
        return this.getDirectory().getUrl();
    }

    public boolean isAvailable() {
        Invoker<T> invoker = this.stickyInvoker;
        if (invoker != null) {
            return invoker.isAvailable();
        }
        return this.getDirectory().isAvailable();
    }

    @Override
    public Directory<T> getDirectory() {
        return this.directory;
    }

    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.getDirectory().destroy();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected Invoker<T> select(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            return null;
        }
        String methodName = invocation == null ? "" : invocation.getMethodName();
        boolean sticky = invokers.get(0).getUrl().getMethodParameter(methodName, "sticky", false);
        if (this.stickyInvoker != null && !invokers.contains(this.stickyInvoker)) {
            this.stickyInvoker = null;
        }
        if (sticky && this.stickyInvoker != null && (selected == null || !selected.contains(this.stickyInvoker)) && this.availableCheck && this.stickyInvoker.isAvailable()) {
            return this.stickyInvoker;
        }
        Invoker<T> invoker = this.doSelect(loadbalance, invocation, invokers, selected);
        if (sticky) {
            this.stickyInvoker = invoker;
        }
        return invoker;
    }

    private Invoker<T> doSelect(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected) throws RpcException {
        boolean isUnavailable;
        if (CollectionUtils.isEmpty(invokers)) {
            return null;
        }
        if (invokers.size() == 1) {
            Invoker<T> tInvoker = invokers.get(0);
            this.checkShouldInvalidateInvoker(tInvoker);
            return tInvoker;
        }
        Invoker<T> invoker = loadbalance.select(invokers, this.getUrl(), invocation);
        boolean isSelected = selected != null && selected.contains(invoker);
        boolean bl = isUnavailable = this.availableCheck && !invoker.isAvailable() && this.getUrl() != null;
        if (isUnavailable) {
            this.invalidateInvoker(invoker);
        }
        if (isSelected || isUnavailable) {
            try {
                Invoker<T> rInvoker = this.reselect(loadbalance, invocation, invokers, selected, this.availableCheck);
                if (rInvoker != null) {
                    invoker = rInvoker;
                } else {
                    int index = invokers.indexOf(invoker);
                    try {
                        invoker = invokers.get((index + 1) % invokers.size());
                    }
                    catch (Exception e) {
                        logger.warn("2-5", "select invokers exception", "", e.getMessage() + " may because invokers list dynamic change, ignore.", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                logger.error("2-5", "failed to reselect invokers", "", "cluster reselect fail reason is :" + t.getMessage() + " if can not solve, you can set cluster.availablecheck=false in url", t);
            }
        }
        return invoker;
    }

    private Invoker<T> reselect(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected, boolean availableCheck) throws RpcException {
        ArrayList reselectInvokers = new ArrayList(Math.min(invokers.size(), this.reselectCount));
        if (this.reselectCount >= invokers.size()) {
            for (Invoker<T> invoker : invokers) {
                if (availableCheck && !invoker.isAvailable()) {
                    this.invalidateInvoker(invoker);
                    continue;
                }
                if (selected != null && selected.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
        } else {
            for (int i = 0; i < this.reselectCount; ++i) {
                Invoker<T> invoker;
                invoker = invokers.get(ThreadLocalRandom.current().nextInt(invokers.size()));
                if (availableCheck && !invoker.isAvailable()) {
                    this.invalidateInvoker(invoker);
                    continue;
                }
                if (selected != null && selected.contains(invoker) && reselectInvokers.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
        }
        if (!reselectInvokers.isEmpty()) {
            return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
        }
        if (selected != null) {
            for (Invoker<T> invoker : selected) {
                if (!invoker.isAvailable() || reselectInvokers.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
        }
        if (!reselectInvokers.isEmpty()) {
            return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
        }
        return null;
    }

    private void checkShouldInvalidateInvoker(Invoker<T> invoker) {
        if (this.availableCheck && !invoker.isAvailable()) {
            this.invalidateInvoker(invoker);
        }
    }

    private void invalidateInvoker(Invoker<T> invoker) {
        if (this.enableConnectivityValidation && this.getDirectory() != null) {
            this.getDirectory().addInvalidateInvoker(invoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invocation invocation) throws RpcException {
        this.checkWhetherDestroyed();
        InvocationProfilerUtils.enterDetailProfiler((Invocation)invocation, () -> "Router route.");
        List<Invoker<T>> invokers = this.list(invocation);
        InvocationProfilerUtils.releaseDetailProfiler((Invocation)invocation);
        LoadBalance loadbalance = this.initLoadBalance(invokers, invocation);
        RpcUtils.attachInvocationIdIfAsync((URL)this.getUrl(), (Invocation)invocation);
        InvocationProfilerUtils.enterDetailProfiler((Invocation)invocation, () -> "Cluster " + this.getClass().getName() + " invoke.");
        try {
            Result result = this.doInvoke(invocation, invokers, loadbalance);
            return result;
        }
        finally {
            InvocationProfilerUtils.releaseDetailProfiler((Invocation)invocation);
        }
    }

    protected void checkWhetherDestroyed() {
        if (this.destroyed.get()) {
            throw new RpcException("Rpc cluster invoker for " + this.getInterface() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + " is now destroyed! Can not invoke any more.");
        }
    }

    public String toString() {
        return this.getInterface() + " -> " + this.getUrl().toString();
    }

    protected void checkInvokers(List<Invoker<T>> invokers, Invocation invocation) {
        if (CollectionUtils.isEmpty(invokers)) {
            throw new RpcException(6, "Failed to invoke the method " + invocation.getMethodName() + " in the service " + this.getInterface().getName() + ". No provider available for the service " + this.getDirectory().getConsumerUrl().getServiceKey() + " from registry " + this.getDirectory().getUrl().getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ". Please check if the providers have been started and registered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result invokeWithContext(Invoker<T> invoker, Invocation invocation) {
        Result result;
        this.setContext(invoker);
        try {
            if (ProfilerSwitch.isEnableSimpleProfiler()) {
                InvocationProfilerUtils.enterProfiler((Invocation)invocation, (String)("Invoker invoke. Target Address: " + invoker.getUrl().getAddress()));
            }
            result = invoker.invoke(invocation);
        }
        finally {
            this.clearContext(invoker);
            InvocationProfilerUtils.releaseSimpleProfiler((Invocation)invocation);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result invokeWithContextAsync(Invoker<T> invoker, Invocation invocation, URL consumerUrl) {
        Result result;
        this.setContext(invoker, consumerUrl);
        try {
            result = invoker.invoke(invocation);
        }
        finally {
            this.clearContext(invoker);
        }
        return result;
    }

    protected abstract Result doInvoke(Invocation var1, List<Invoker<T>> var2, LoadBalance var3) throws RpcException;

    protected List<Invoker<T>> list(Invocation invocation) throws RpcException {
        return this.getDirectory().list(invocation);
    }

    protected LoadBalance initLoadBalance(List<Invoker<T>> invokers, Invocation invocation) {
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel((ScopeModel)invocation.getModuleModel());
        if (CollectionUtils.isNotEmpty(invokers)) {
            return (LoadBalance)applicationModel.getExtensionLoader(LoadBalance.class).getExtension(invokers.get(0).getUrl().getMethodParameter(RpcUtils.getMethodName((Invocation)invocation), "loadbalance", "random"));
        }
        return (LoadBalance)applicationModel.getExtensionLoader(LoadBalance.class).getExtension("random");
    }

    private void setContext(Invoker<T> invoker) {
        this.setContext(invoker, null);
    }

    private void setContext(Invoker<T> invoker, URL consumerUrl) {
        RpcServiceContext context = RpcContext.getServiceContext();
        context.setInvoker(invoker).setConsumerUrl(null != consumerUrl ? consumerUrl : RpcContext.getServiceContext().getConsumerUrl());
    }

    private void clearContext(Invoker<T> invoker) {
        RpcServiceContext context = RpcContext.getServiceContext();
        context.setInvoker(null);
    }
}

