/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.Ring;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public class DefaultExecutorRepository
implements ExecutorRepository {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutorRepository.class);
    private int DEFAULT_SCHEDULER_SIZE = Runtime.getRuntime().availableProcessors();
    private final ExecutorService SHARED_EXECUTOR = Executors.newCachedThreadPool(new NamedThreadFactory("DubboSharedHandler", true));
    private Ring<ScheduledExecutorService> scheduledExecutors = new Ring();
    private ScheduledExecutorService serviceExporterExecutor;
    private ScheduledExecutorService reconnectScheduledExecutor;
    private ConcurrentMap<String, ConcurrentMap<Integer, ExecutorService>> data = new ConcurrentHashMap<String, ConcurrentMap<Integer, ExecutorService>>();

    public DefaultExecutorRepository() {
        for (int i = 0; i < this.DEFAULT_SCHEDULER_SIZE; ++i) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-scheduler"));
            this.scheduledExecutors.addItem(scheduler);
        }
        this.serviceExporterExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Dubbo-exporter-scheduler"));
    }

    @Override
    public synchronized ExecutorService createExecutorIfAbsent(URL url) {
        Integer portKey;
        Map executors;
        ExecutorService executor;
        String componentKey = CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY;
        if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
            componentKey = "consumer";
        }
        if ((executor = (executors = (Map)this.data.computeIfAbsent(componentKey, k -> new ConcurrentHashMap())).computeIfAbsent(portKey = Integer.valueOf(url.getPort()), k -> this.createExecutor(url))).isShutdown() || executor.isTerminated()) {
            executors.remove(portKey);
            executor = this.createExecutor(url);
            executors.put(portKey, executor);
        }
        return executor;
    }

    @Override
    public ExecutorService getExecutor(URL url) {
        Map executors;
        String componentKey = CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY;
        if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
            componentKey = "consumer";
        }
        if ((executors = (Map)this.data.get(componentKey)) == null) {
            logger.warn("No available executors, this is not expected, framework should call createExecutorIfAbsent first before coming to here.");
            return null;
        }
        Integer portKey = url.getPort();
        ExecutorService executor = (ExecutorService)executors.get(portKey);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            executors.remove(portKey);
            executor = this.createExecutor(url);
            executors.put(portKey, executor);
        }
        return executor;
    }

    @Override
    public void updateThreadpool(URL url, ExecutorService executor) {
        try {
            if (url.hasParameter("threads") && executor instanceof ThreadPoolExecutor && !executor.isShutdown()) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                int threads = url.getParameter("threads", 0);
                int max = threadPoolExecutor.getMaximumPoolSize();
                int core = threadPoolExecutor.getCorePoolSize();
                if (threads > 0 && (threads != max || threads != core)) {
                    if (threads < core) {
                        threadPoolExecutor.setCorePoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setMaximumPoolSize(threads);
                        }
                    } else {
                        threadPoolExecutor.setMaximumPoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setCorePoolSize(threads);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public ScheduledExecutorService nextScheduledExecutor() {
        return this.scheduledExecutors.pollItem();
    }

    @Override
    public ScheduledExecutorService getServiceExporterExecutor() {
        return this.serviceExporterExecutor;
    }

    @Override
    public ExecutorService getSharedExecutor() {
        return this.SHARED_EXECUTOR;
    }

    private ExecutorService createExecutor(URL url) {
        return (ExecutorService)ExtensionLoader.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
    }
}

