/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.bytecode;

import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.dubbo.common.bytecode.ClassGenerator;
import org.apache.dubbo.common.utils.ReflectUtils;

public abstract class Proxy {
    public static final InvocationHandler RETURN_NULL_INVOKER = (proxy, method, args) -> null;
    public static final InvocationHandler THROW_UNSUPPORTED_INVOKER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            throw new UnsupportedOperationException("Method [" + ReflectUtils.getName(method) + "] unimplemented.");
        }
    };
    private static final AtomicLong PROXY_CLASS_COUNTER = new AtomicLong(0L);
    private static final String PACKAGE_NAME = Proxy.class.getPackage().getName();
    private static final Map<ClassLoader, Map<String, Object>> PROXY_CACHE_MAP = new WeakHashMap<ClassLoader, Map<String, Object>>();
    private static final Map<ClassLoader, Map<String, Object>> PROXY_CLASS_MAP = new WeakHashMap<ClassLoader, Map<String, Object>>();
    private static final Object PENDING_GENERATION_MARKER = new Object();

    protected Proxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Proxy getProxy(Class<?> ... ics) {
        if (ics.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        cl = ics[0].getClassLoader();
        appClassLoader = ics[0].getClassLoader();
        domain = ics[0].getProtectionDomain();
        sb = new StringBuilder();
        for (i = 0; i < ics.length; ++i) {
            itf = ics[i].getName();
            if (!ics[i].isInterface()) {
                throw new RuntimeException(itf + " is not a interface.");
            }
            tmp = null;
            try {
                tmp = Class.forName(itf, false, cl);
            }
            catch (ClassNotFoundException var8_9) {
                // empty catch block
            }
            if (tmp != ics[i]) {
                throw new IllegalArgumentException(ics[i] + " is not visible from class loader");
            }
            sb.append(itf).append(';');
        }
        key = sb.toString();
        var8_10 = Proxy.PROXY_CACHE_MAP;
        synchronized (var8_10) {
            cache = Proxy.PROXY_CACHE_MAP.computeIfAbsent(cl, (Function<ClassLoader, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getProxy$1(java.lang.ClassLoader ), (Ljava/lang/ClassLoader;)Ljava/util/Map;)());
            classCache = Proxy.PROXY_CLASS_MAP.computeIfAbsent(cl, (Function<ClassLoader, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getProxy$2(java.lang.ClassLoader ), (Ljava/lang/ClassLoader;)Ljava/util/Map;)());
        }
        proxy = null;
        var9_11 = cache;
        synchronized (var9_11) {
            while (true) {
                if ((value = cache.get(key)) instanceof Reference && (proxy = (Proxy)((Reference)value).get()) != null) {
                    return proxy;
                }
                clazzObj = classCache.get(key);
                if (null != clazzObj && !(clazzObj instanceof Reference)) continue;
                clazz = null;
                if (clazzObj instanceof Reference) {
                    clazz = (Class)((Reference)clazzObj).get();
                }
                if (null != clazz) ** break block47
                if (value != Proxy.PENDING_GENERATION_MARKER) break;
                try {
                    cache.wait();
                }
                catch (InterruptedException var13_16) {}
            }
            cache.put(key, Proxy.PENDING_GENERATION_MARKER);
        }
        id = Proxy.PROXY_CLASS_COUNTER.getAndIncrement();
        pkg = null;
        ccp = null;
        ccm = null;
        try {
            ccp = ClassGenerator.newInstance(cl);
            worked = new HashSet<String>();
            methods = new ArrayList<Method>();
            for (i = 0; i < ics.length; ++i) {
                if (!Modifier.isPublic(ics[i].getModifiers())) {
                    npkg = ics[i].getPackage().getName();
                    if (pkg == null) {
                        pkg = npkg;
                    } else if (!pkg.equals(npkg)) {
                        throw new IllegalArgumentException("non-public interfaces from different packages");
                    }
                }
                ccp.addInterface(ics[i]);
                for (Method method : ics[i].getMethods()) {
                    desc = ReflectUtils.getDesc(method);
                    if (worked.contains(desc) || Modifier.isStatic(method.getModifiers())) continue;
                    worked.add(desc);
                    ix = methods.size();
                    rt = method.getReturnType();
                    pts = method.getParameterTypes();
                    code = new StringBuilder("Object[] args = new Object[").append(pts.length).append("];");
                    for (j = 0; j < pts.length; ++j) {
                        code.append(" args[").append(j).append("] = ($w)$").append(j + 1).append(";");
                    }
                    code.append(" Object ret = handler.invoke(this, methods[").append(ix).append("], args);");
                    if (!Void.TYPE.equals(rt)) {
                        code.append(" return ").append(Proxy.asArgument(rt, "ret")).append(';');
                    }
                    methods.add(method);
                    ccp.addMethod(method.getName(), method.getModifiers(), rt, pts, method.getExceptionTypes(), code.toString());
                }
            }
            if (pkg == null) {
                pkg = Proxy.PACKAGE_NAME;
            }
            pcn = pkg + ".proxy" + id;
            ccp.setClassName(pcn);
            ccp.addField("public static java.lang.reflect.Method[] methods;");
            ccp.addField("private " + InvocationHandler.class.getName() + " handler;");
            ccp.addConstructor(1, new Class[]{InvocationHandler.class}, new Class[0], "handler=$1;");
            ccp.addDefaultConstructor();
            clazz = ccp.toClass(appClassLoader, domain);
            clazz.getField("methods").set(null, methods.toArray(new Method[0]));
            fcn = Proxy.class.getName() + id;
            ccm = ClassGenerator.newInstance(cl);
            ccm.setClassName(fcn);
            ccm.addDefaultConstructor();
            ccm.setSuperClass(Proxy.class);
            ccm.addMethod("public Object newInstance(" + InvocationHandler.class.getName() + " h){ return new " + pcn + "($1); }");
            pc = ccm.toClass(appClassLoader, domain);
            proxy = (Proxy)pc.newInstance();
            var20_32 = classCache;
            synchronized (var20_32) {
                classCache.put(key, new SoftReference<Class<?>>(pc));
                return proxy;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        {
            try {
                var13_17 = proxy = (Proxy)clazz.newInstance();
                return var13_17;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (null == proxy) {
                    cache.remove(key);
                } else {
                    cache.put(key, new SoftReference<Proxy>(proxy));
                }
            }
        }
        finally {
            if (ccp != null) {
                ccp.release();
            }
            if (ccm != null) {
                ccm.release();
            }
            var30_40 = cache;
            synchronized (var30_40) {
                if (proxy == null) {
                    cache.remove(key);
                } else {
                    cache.put(key, new SoftReference<Proxy>(proxy));
                }
                cache.notifyAll();
            }
        }
    }

    private static String asArgument(Class<?> cl, String name) {
        if (cl.isPrimitive()) {
            if (Boolean.TYPE == cl) {
                return name + "==null?false:((Boolean)" + name + ").booleanValue()";
            }
            if (Byte.TYPE == cl) {
                return name + "==null?(byte)0:((Byte)" + name + ").byteValue()";
            }
            if (Character.TYPE == cl) {
                return name + "==null?(char)0:((Character)" + name + ").charValue()";
            }
            if (Double.TYPE == cl) {
                return name + "==null?(double)0:((Double)" + name + ").doubleValue()";
            }
            if (Float.TYPE == cl) {
                return name + "==null?(float)0:((Float)" + name + ").floatValue()";
            }
            if (Integer.TYPE == cl) {
                return name + "==null?(int)0:((Integer)" + name + ").intValue()";
            }
            if (Long.TYPE == cl) {
                return name + "==null?(long)0:((Long)" + name + ").longValue()";
            }
            if (Short.TYPE == cl) {
                return name + "==null?(short)0:((Short)" + name + ").shortValue()";
            }
            throw new RuntimeException(name + " is unknown primitive type.");
        }
        return "(" + ReflectUtils.getName(cl) + ")" + name;
    }

    public Object newInstance() {
        return this.newInstance(THROW_UNSUPPORTED_INVOKER);
    }

    public abstract Object newInstance(InvocationHandler var1);

    private static /* synthetic */ Map lambda$getProxy$2(ClassLoader k) {
        return new HashMap();
    }

    private static /* synthetic */ Map lambda$getProxy$1(ClassLoader k) {
        return new HashMap();
    }
}

