/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CompatibleTypeUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.SerializeClassChecker;

public class PojoUtils {
    private static final Logger logger = LoggerFactory.getLogger(PojoUtils.class);
    private static final ConcurrentMap<String, Method> NAME_METHODS_CACHE = new ConcurrentHashMap<String, Method>();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final boolean GENERIC_WITH_CLZ = Boolean.parseBoolean(ConfigurationUtils.getProperty("generic.include.class", "true"));
    private static final List<Class<?>> CLASS_CAN_BE_STRING = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class);

    public static Object[] generalize(Object[] objs) {
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.generalize(objs[i]);
        }
        return dests;
    }

    public static Object[] realize(Object[] objs, Class<?>[] types) {
        if (objs.length != types.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.realize(objs[i], types[i]);
        }
        return dests;
    }

    public static Object[] realize(Object[] objs, Class<?>[] types, Type[] gtypes) {
        if (objs.length != types.length || objs.length != gtypes.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] dests = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            dests[i] = PojoUtils.realize(objs[i], types[i], gtypes[i]);
        }
        return dests;
    }

    public static Object generalize(Object pojo) {
        return PojoUtils.generalize(pojo, new IdentityHashMap<Object, Object>());
    }

    private static Object generalize(Object pojo, Map<Object, Object> history) {
        if (pojo == null) {
            return null;
        }
        if (pojo instanceof Enum) {
            return ((Enum)pojo).name();
        }
        if (pojo.getClass().isArray() && Enum.class.isAssignableFrom(pojo.getClass().getComponentType())) {
            int len = Array.getLength(pojo);
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = ((Enum)Array.get(pojo, i)).name();
            }
            return values;
        }
        if (ReflectUtils.isPrimitives(pojo.getClass())) {
            return pojo;
        }
        if (pojo instanceof Class) {
            return ((Class)pojo).getName();
        }
        Object o = history.get(pojo);
        if (o != null) {
            return o;
        }
        history.put(pojo, pojo);
        if (pojo.getClass().isArray()) {
            int len = Array.getLength(pojo);
            Object[] dest = new Object[len];
            history.put(pojo, dest);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(pojo, i);
                dest[i] = PojoUtils.generalize(obj, history);
            }
            return dest;
        }
        if (pojo instanceof Collection) {
            Collection src = (Collection)pojo;
            int len = src.size();
            AbstractCollection dest = pojo instanceof List ? new ArrayList(len) : new HashSet(len);
            history.put(pojo, dest);
            for (Object e : src) {
                dest.add(PojoUtils.generalize(e, history));
            }
            return dest;
        }
        if (pojo instanceof Map) {
            Map src = (Map)pojo;
            Map dest = PojoUtils.createMap(src);
            history.put(pojo, dest);
            for (Map.Entry obj : src.entrySet()) {
                dest.put(PojoUtils.generalize(obj.getKey(), history), PojoUtils.generalize(obj.getValue(), history));
            }
            return dest;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        history.put(pojo, map);
        if (GENERIC_WITH_CLZ) {
            map.put("class", pojo.getClass().getName());
        }
        for (Method method : pojo.getClass().getMethods()) {
            if (!ReflectUtils.isBeanPropertyReadMethod(method)) continue;
            ReflectUtils.makeAccessible(method);
            try {
                map.put(ReflectUtils.getPropertyNameFromBeanReadMethod(method), PojoUtils.generalize(method.invoke(pojo, new Object[0]), history));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        for (AccessibleObject accessibleObject : pojo.getClass().getFields()) {
            if (!ReflectUtils.isPublicInstanceField((Field)accessibleObject)) continue;
            try {
                Object pojoGeneralizedValue;
                Object fieldValue = ((Field)accessibleObject).get(pojo);
                if (history.containsKey(pojo) && (pojoGeneralizedValue = history.get(pojo)) instanceof Map && ((Map)pojoGeneralizedValue).containsKey(((Field)accessibleObject).getName()) || fieldValue == null) continue;
                map.put(((Field)accessibleObject).getName(), PojoUtils.generalize(fieldValue, history));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return map;
    }

    public static Object realize(Object pojo, Class<?> type) {
        return PojoUtils.realize0(pojo, type, null, new IdentityHashMap<Object, Object>());
    }

    public static Object realize(Object pojo, Class<?> type, Type genericType) {
        return PojoUtils.realize0(pojo, type, genericType, new IdentityHashMap<Object, Object>());
    }

    private static Collection<Object> createCollection(Class<?> type, int len) {
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>(len);
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>(len);
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static Map createMap(Map src) {
        Class<?> cl = src.getClass();
        Map result = null;
        if (HashMap.class == cl) {
            result = new HashMap();
        } else if (Hashtable.class == cl) {
            result = new Hashtable();
        } else if (IdentityHashMap.class == cl) {
            result = new IdentityHashMap();
        } else if (LinkedHashMap.class == cl) {
            result = new LinkedHashMap();
        } else if (Properties.class == cl) {
            result = new Properties();
        } else if (TreeMap.class == cl) {
            result = new TreeMap();
        } else {
            if (WeakHashMap.class == cl) {
                return new WeakHashMap();
            }
            if (ConcurrentHashMap.class == cl) {
                result = new ConcurrentHashMap();
            } else if (ConcurrentSkipListMap.class == cl) {
                result = new ConcurrentSkipListMap();
            } else {
                try {
                    result = (Map)cl.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (result == null) {
                    try {
                        Constructor<?> constructor = cl.getConstructor(Map.class);
                        result = (Map)constructor.newInstance(Collections.EMPTY_MAP);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private static Object realize0(Object pojo, Class<?> type, Type genericType, Map<Object, Object> history) {
        if (pojo == null) {
            return null;
        }
        if (type != null && type.isEnum() && pojo.getClass() == String.class) {
            return Enum.valueOf(type, (String)pojo);
        }
        if (!(!ReflectUtils.isPrimitives(pojo.getClass()) || type != null && type.isArray() && type.getComponentType().isEnum() && pojo.getClass() == String[].class)) {
            return CompatibleTypeUtils.compatibleTypeConvert(pojo, type);
        }
        Object o = history.get(pojo);
        if (o != null) {
            return o;
        }
        history.put(pojo, pojo);
        if (pojo.getClass().isArray()) {
            if (Collection.class.isAssignableFrom(type)) {
                Class<?> ctype = pojo.getClass().getComponentType();
                int len = Array.getLength(pojo);
                Collection<Object> dest = PojoUtils.createCollection(type, len);
                history.put(pojo, dest);
                for (int i = 0; i < len; ++i) {
                    Object obj = Array.get(pojo, i);
                    Object value = PojoUtils.realize0(obj, ctype, null, history);
                    dest.add(value);
                }
                return dest;
            }
            Class<?> ctype = type != null && type.isArray() ? type.getComponentType() : pojo.getClass().getComponentType();
            int len = Array.getLength(pojo);
            Object dest = Array.newInstance(ctype, len);
            history.put(pojo, dest);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(pojo, i);
                Object value = PojoUtils.realize0(obj, ctype, null, history);
                Array.set(dest, i, value);
            }
            return dest;
        }
        if (pojo instanceof Collection) {
            if (type.isArray()) {
                Class<?> ctype = type.getComponentType();
                Collection src = (Collection)pojo;
                int len = src.size();
                Object dest = Array.newInstance(ctype, len);
                history.put(pojo, dest);
                int i = 0;
                for (Object obj : src) {
                    Object value = PojoUtils.realize0(obj, ctype, null, history);
                    Array.set(dest, i, value);
                    ++i;
                }
                return dest;
            }
            Collection src = (Collection)pojo;
            int len = src.size();
            Collection<Object> dest = PojoUtils.createCollection(type, len);
            history.put(pojo, dest);
            for (Object obj : src) {
                Class keyClazz;
                Type keyType = PojoUtils.getGenericClassByIndex(genericType, 0);
                Class clazz = keyClazz = obj == null ? null : obj.getClass();
                if (keyType instanceof Class) {
                    keyClazz = (Class)keyType;
                }
                Object value = PojoUtils.realize0(obj, keyClazz, keyType, history);
                dest.add(value);
            }
            return dest;
        }
        if (pojo instanceof Map && type != null) {
            Object message;
            Object dest;
            Map map;
            Object name;
            Object className = ((Map)pojo).get("class");
            if (className instanceof String) {
                SerializeClassChecker.getInstance().validateClass((String)className);
                try {
                    type = ClassUtils.forName((String)className);
                }
                catch (ClassNotFoundException len) {
                    // empty catch block
                }
            }
            if (type.isEnum() && (name = ((Map)pojo).get("name")) != null) {
                if (!(name instanceof String)) {
                    throw new IllegalArgumentException("`name` filed should be string!");
                }
                return Enum.valueOf(type, (String)name);
            }
            if (!type.isInterface() && !type.isAssignableFrom(pojo.getClass())) {
                try {
                    map = (Map)type.newInstance();
                    Map mapPojo = (Map)pojo;
                    map.putAll(mapPojo);
                    if (GENERIC_WITH_CLZ) {
                        map.remove("class");
                    }
                }
                catch (Exception e) {
                    map = (Map)pojo;
                }
            } else {
                map = (Map)pojo;
            }
            if (Map.class.isAssignableFrom(type) || type == Object.class) {
                Type mapKeyType = PojoUtils.getKeyTypeForMap(map.getClass());
                Type typeKeyType = PojoUtils.getGenericClassByIndex(genericType, 0);
                boolean typeMismatch = mapKeyType instanceof Class && typeKeyType instanceof Class && !typeKeyType.getTypeName().equals(mapKeyType.getTypeName());
                Map result = typeMismatch ? PojoUtils.createMap(new HashMap(0)) : PojoUtils.createMap(map);
                history.put(pojo, result);
                for (Map.Entry entry : map.entrySet()) {
                    Class keyClazz;
                    Type keyType = PojoUtils.getGenericClassByIndex(genericType, 0);
                    Type valueType = PojoUtils.getGenericClassByIndex(genericType, 1);
                    if (keyType instanceof Class) {
                        keyClazz = (Class)keyType;
                    } else if (keyType instanceof ParameterizedType) {
                        keyClazz = (Class)((ParameterizedType)keyType).getRawType();
                    } else {
                        Class clazz = keyClazz = entry.getKey() == null ? null : entry.getKey().getClass();
                    }
                    Class<Object> valueClazz = valueType instanceof Class ? (Class<Object>)valueType : (valueType instanceof ParameterizedType ? (Class)((ParameterizedType)valueType).getRawType() : (entry.getValue() == null ? null : entry.getValue().getClass()));
                    Object key = keyClazz == null ? entry.getKey() : PojoUtils.realize0(entry.getKey(), keyClazz, keyType, history);
                    Object value = valueClazz == null ? entry.getValue() : PojoUtils.realize0(entry.getValue(), valueClazz, valueType, history);
                    result.put(key, value);
                }
                return result;
            }
            if (type.isInterface()) {
                dest = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (InvocationHandler)new PojoInvocationHandler(map));
                history.put(pojo, dest);
                return dest;
            }
            dest = PojoUtils.newInstance(type);
            history.put(pojo, dest);
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String name2 = (String)key;
                Object value = entry.getValue();
                if (value == null) continue;
                Method method = PojoUtils.getSetterMethod(dest.getClass(), name2, value.getClass());
                Field field = PojoUtils.getField(dest.getClass(), name2);
                if (method != null) {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    Type ptype = method.getGenericParameterTypes()[0];
                    value = PojoUtils.realize0(value, method.getParameterTypes()[0], ptype, history);
                    try {
                        method.invoke(dest, value);
                        continue;
                    }
                    catch (Exception e) {
                        String exceptionDescription = "Failed to set pojo " + dest.getClass().getSimpleName() + " property " + name2 + " value " + value.getClass() + ", cause: " + e.getMessage();
                        logger.error(exceptionDescription, e);
                        throw new RuntimeException(exceptionDescription, e);
                    }
                }
                if (field == null) continue;
                value = PojoUtils.realize0(value, field.getType(), field.getGenericType(), history);
                try {
                    field.set(dest, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to set field " + name2 + " of pojo " + dest.getClass().getName() + " : " + e.getMessage(), e);
                }
            }
            if (dest instanceof Throwable && (message = map.get("message")) instanceof String) {
                try {
                    Field field = Throwable.class.getDeclaredField("detailMessage");
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(dest, message);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return dest;
        }
        return pojo;
    }

    private static Type getKeyTypeForMap(Class<?> clazz) {
        Object[] interfaces = clazz.getGenericInterfaces();
        if (!ArrayUtils.isEmpty(interfaces)) {
            for (Object type : interfaces) {
                ParameterizedType t;
                if (!(type instanceof ParameterizedType) || !"java.util.Map".equals((t = (ParameterizedType)type).getRawType().getTypeName())) continue;
                return t.getActualTypeArguments()[0];
            }
        }
        return null;
    }

    private static Type getGenericClassByIndex(Type genericType, int index) {
        Type clazz = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)genericType;
            Type[] types = t.getActualTypeArguments();
            clazz = types[index];
        }
        return clazz;
    }

    private static Object newInstance(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Throwable t) {
            try {
                Constructor<?>[] constructors = cls.getDeclaredConstructors();
                if (constructors.length == 0) {
                    throw new RuntimeException("Illegal constructor: " + cls.getName());
                }
                Constructor<?> constructor = constructors[0];
                if (constructor.getParameterTypes().length > 0) {
                    for (Constructor<?> c : constructors) {
                        if (c.getParameterTypes().length < constructor.getParameterTypes().length && (constructor = c).getParameterTypes().length == 0) break;
                    }
                }
                constructor.setAccessible(true);
                Object[] parameters = Arrays.stream(constructor.getParameterTypes()).map(PojoUtils::getDefaultValue).toArray();
                return constructor.newInstance(parameters);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static Object getDefaultValue(Class<?> parameterType) {
        if ("char".equals(parameterType.getName())) {
            return Character.valueOf('\u0000');
        }
        if ("boolean".equals(parameterType.getName())) {
            return false;
        }
        if ("byte".equals(parameterType.getName())) {
            return (byte)0;
        }
        if ("short".equals(parameterType.getName())) {
            return (short)0;
        }
        return parameterType.isPrimitive() ? Integer.valueOf(0) : null;
    }

    private static Method getSetterMethod(Class<?> cls, String property, Class<?> valueCls) {
        String name = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method method = (Method)NAME_METHODS_CACHE.get(cls.getName() + "." + name + "(" + valueCls.getName() + ")");
        if (method == null) {
            try {
                method = cls.getMethod(name, valueCls);
            }
            catch (NoSuchMethodException e) {
                for (Method m : cls.getMethods()) {
                    if (!ReflectUtils.isBeanPropertyWriteMethod(m) || !m.getName().equals(name)) continue;
                    method = m;
                    break;
                }
            }
            if (method != null) {
                NAME_METHODS_CACHE.put(cls.getName() + "." + name + "(" + valueCls.getName() + ")", method);
            }
        }
        return method;
    }

    private static Field getField(Class<?> cls, String fieldName) {
        Field result = null;
        if (CLASS_FIELD_CACHE.containsKey(cls) && ((ConcurrentMap)CLASS_FIELD_CACHE.get(cls)).containsKey(fieldName)) {
            return (Field)((ConcurrentMap)CLASS_FIELD_CACHE.get(cls)).get(fieldName);
        }
        try {
            result = cls.getDeclaredField(fieldName);
            result.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            for (Field field : cls.getFields()) {
                if (!fieldName.equals(field.getName()) || !ReflectUtils.isPublicInstanceField(field)) continue;
                result = field;
                break;
            }
        }
        if (result != null) {
            ConcurrentMap fields = CLASS_FIELD_CACHE.computeIfAbsent(cls, k -> new ConcurrentHashMap());
            fields.putIfAbsent(fieldName, result);
        }
        return result;
    }

    public static boolean isPojo(Class<?> cls) {
        return !ReflectUtils.isPrimitives(cls) && !Collection.class.isAssignableFrom(cls) && !Map.class.isAssignableFrom(cls);
    }

    public static <T> void updatePropertyIfAbsent(Supplier<T> getterMethod, Consumer<T> setterMethod, T newValue) {
        if (newValue != null && getterMethod.get() == null) {
            setterMethod.accept(newValue);
        }
    }

    public static <T> T mapToPojo(Map<String, Object> map, Class<T> cls) throws ReflectiveOperationException {
        T instance = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Map<String, Field> beanPropertyFields = ReflectUtils.getBeanPropertyFields(cls);
        for (Map.Entry<String, Field> entry : beanPropertyFields.entrySet()) {
            String name = entry.getKey();
            Field field = entry.getValue();
            Object mapObject = map.get(name);
            if (mapObject == null) continue;
            Type type = field.getGenericType();
            Object fieldObject = PojoUtils.getFieldObject(mapObject, type);
            field.set(instance, fieldObject);
        }
        return instance;
    }

    private static Object getFieldObject(Object mapObject, Type fieldType) throws ReflectiveOperationException {
        if (fieldType instanceof Class) {
            return PojoUtils.convertClassType(mapObject, (Class)fieldType);
        }
        if (fieldType instanceof ParameterizedType) {
            return PojoUtils.convertParameterizedType(mapObject, (ParameterizedType)fieldType);
        }
        if (fieldType instanceof GenericArrayType || fieldType instanceof TypeVariable || fieldType instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("Unrecognized Type: " + fieldType.toString());
    }

    private static Object convertClassType(Object mapObject, Class<?> type) throws ReflectiveOperationException {
        if (type.isPrimitive() || ClassUtils.isAssignableFrom(type, mapObject.getClass())) {
            return mapObject;
        }
        if (Objects.equals(type, String.class) && CLASS_CAN_BE_STRING.contains(mapObject.getClass())) {
            return mapObject.toString();
        }
        if (mapObject instanceof Map) {
            return PojoUtils.mapToPojo((Map)mapObject, type);
        }
        return null;
    }

    private static Object convertParameterizedType(Object mapObject, ParameterizedType type) throws ReflectiveOperationException {
        Type rawType = type.getRawType();
        if (!ClassUtils.isAssignableFrom((Class)rawType, mapObject.getClass())) {
            return null;
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (ClassUtils.isAssignableFrom(Map.class, (Class)rawType)) {
            Map map = (Map)mapObject.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Map.Entry entry : ((Map)mapObject).entrySet()) {
                Object key = PojoUtils.getFieldObject(entry.getKey(), actualTypeArguments[0]);
                Object value = PojoUtils.getFieldObject(entry.getValue(), actualTypeArguments[1]);
                map.put(key, value);
            }
            return map;
        }
        if (ClassUtils.isAssignableFrom(Collection.class, (Class)rawType)) {
            Collection collection = (Collection)mapObject.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Object m : (Iterable)mapObject) {
                Object ele = PojoUtils.getFieldObject(m, actualTypeArguments[0]);
                collection.add(ele);
            }
            return collection;
        }
        return null;
    }

    private static class PojoInvocationHandler
    implements InvocationHandler {
        private Map<Object, Object> map;

        public PojoInvocationHandler(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(this.map, args);
            }
            String methodName = method.getName();
            Object value = null;
            value = methodName.length() > 3 && methodName.startsWith("get") ? this.map.get(methodName.substring(3, 4).toLowerCase() + methodName.substring(4)) : (methodName.length() > 2 && methodName.startsWith("is") ? this.map.get(methodName.substring(2, 3).toLowerCase() + methodName.substring(3)) : this.map.get(methodName.substring(0, 1).toLowerCase() + methodName.substring(1)));
            if (value instanceof Map && !Map.class.isAssignableFrom(method.getReturnType())) {
                value = PojoUtils.realize0((Map)value, method.getReturnType(), null, new IdentityHashMap());
            }
            return value;
        }
    }
}

