/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.PathURLAddress;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.CollectionUtils;

public class ServiceConfigURL
extends URL {
    private volatile transient String full;
    private volatile transient String string;
    private volatile transient String identity;
    private volatile transient String parameter;

    public ServiceConfigURL() {
    }

    public ServiceConfigURL(URLAddress urlAddress, URLParam urlParam, Map<String, Object> attributes) {
        super(urlAddress, urlParam, attributes);
    }

    public ServiceConfigURL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, (Map<String, String>)null);
    }

    public ServiceConfigURL(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public ServiceConfigURL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public ServiceConfigURL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, (Map<String, String>)null);
    }

    public ServiceConfigURL(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public ServiceConfigURL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path) {
        this(protocol, username, password, host, port, path, (Map<String, String>)null);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, String ... pairs) {
        this(protocol, username, password, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(new PathURLAddress(protocol, username, password, path, host, port), URLParam.parse(parameters), null);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Object> attributes) {
        this(new PathURLAddress(protocol, username, password, path, host, port), URLParam.parse(parameters), attributes);
    }

    @Override
    protected <T extends URL> T newURL(URLAddress urlAddress, URLParam urlParam) {
        return (T)new ServiceConfigURL(urlAddress, urlParam, this.attributes);
    }

    @Override
    public URL addAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            newAttributes.putAll(this.attributes);
        }
        newAttributes.putAll(attributes);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public ServiceConfigURL putAttribute(String key, Object obj) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            newAttributes.putAll(this.attributes);
        }
        newAttributes.put(key, obj);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public URL removeAttribute(String key) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            newAttributes.putAll(this.attributes);
        }
        newAttributes.remove(key);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = super.toString();
        return this.string;
    }

    @Override
    public String toFullString() {
        if (this.full != null) {
            return this.full;
        }
        this.full = super.toFullString();
        return this.full;
    }

    @Override
    public String toIdentityString() {
        if (this.identity != null) {
            return this.identity;
        }
        this.identity = super.toIdentityString();
        return this.identity;
    }

    @Override
    public String toParameterString() {
        if (this.parameter != null) {
            return this.parameter;
        }
        this.parameter = super.toParameterString();
        return this.parameter;
    }
}

