/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;

public class FrameworkModel
extends ScopeModel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FrameworkModel.class);
    public static final String NAME = "FrameworkModel";
    private static final AtomicLong index = new AtomicLong(1L);
    private final AtomicLong appIndex = new AtomicLong(0L);
    private static Object globalLock = new Object();
    private static volatile FrameworkModel defaultInstance;
    private volatile ApplicationModel defaultAppModel;
    private static List<FrameworkModel> allInstances;
    private List<ApplicationModel> applicationModels = new CopyOnWriteArrayList<ApplicationModel>();
    private List<ApplicationModel> pubApplicationModels = new CopyOnWriteArrayList<ApplicationModel>();
    private FrameworkServiceRepository serviceRepository;
    private ApplicationModel internalApplicationModel;
    private Object instLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkModel() {
        super(null, ExtensionScope.FRAMEWORK, false);
        this.setInternalId(String.valueOf(index.getAndIncrement()));
        Object object = globalLock;
        synchronized (object) {
            allInstances.add(this);
            FrameworkModel.resetDefaultFrameworkModel();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getDesc() + " is created");
        }
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        TypeDefinitionBuilder.initBuilders(this);
        this.serviceRepository = new FrameworkServiceRepository(this);
        ExtensionLoader<ScopeModelInitializer> initializerExtensionLoader = this.getExtensionLoader(ScopeModelInitializer.class);
        Set<ScopeModelInitializer> initializers = initializerExtensionLoader.getSupportedExtensionInstances();
        for (ScopeModelInitializer initializer : initializers) {
            initializer.initializeFrameworkModel(this);
        }
        this.internalApplicationModel = new ApplicationModel(this, true);
        this.internalApplicationModel.getApplicationConfigManager().setApplication(new ApplicationConfig(this.internalApplicationModel, "DUBBO_INTERNAL_APPLICATION"));
        this.internalApplicationModel.setModelName("DUBBO_INTERNAL_APPLICATION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDestroy() {
        if (defaultInstance == this && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroying default framework model: " + this.getDesc());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getDesc() + " is destroying ...");
        }
        for (ApplicationModel applicationModel : new ArrayList<ApplicationModel>(this.applicationModels)) {
            applicationModel.destroy();
        }
        this.checkApplicationDestroy();
        this.notifyDestroy();
        this.checkApplicationDestroy();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getDesc() + " is destroyed");
        }
        Object object = globalLock;
        synchronized (object) {
            allInstances.remove(this);
            FrameworkModel.resetDefaultFrameworkModel();
        }
        this.destroyGlobalResources();
    }

    private void checkApplicationDestroy() {
        if (this.applicationModels.size() > 0) {
            List remainApplications = this.applicationModels.stream().map(model -> model.getDesc()).collect(Collectors.toList());
            throw new IllegalStateException("Not all application models are completely destroyed, remaining " + remainApplications.size() + " application models may be created during destruction: " + remainApplications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGlobalResources() {
        Object object = globalLock;
        synchronized (object) {
            if (allInstances.isEmpty()) {
                GlobalResourcesRepository.getInstance().destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameworkModel defaultModel() {
        FrameworkModel instance = defaultInstance;
        if (instance == null) {
            Object object = globalLock;
            synchronized (object) {
                FrameworkModel.resetDefaultFrameworkModel();
                if (defaultInstance == null) {
                    defaultInstance = new FrameworkModel();
                }
                instance = defaultInstance;
            }
        }
        Assert.notNull((Object)instance, "Default FrameworkModel is null");
        return instance;
    }

    public static List<FrameworkModel> getAllInstances() {
        return Collections.unmodifiableList(new ArrayList<FrameworkModel>(allInstances));
    }

    public static void destroyAll() {
        for (FrameworkModel frameworkModel : new ArrayList<FrameworkModel>(allInstances)) {
            frameworkModel.destroy();
        }
    }

    public ApplicationModel newApplication() {
        return new ApplicationModel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationModel defaultApplication() {
        ApplicationModel appModel = this.defaultAppModel;
        if (appModel == null) {
            this.checkDestroyed();
            this.resetDefaultAppModel();
            appModel = this.defaultAppModel;
            if (appModel == null) {
                Object object = this.instLock;
                synchronized (object) {
                    if (this.defaultAppModel == null) {
                        this.defaultAppModel = this.newApplication();
                    }
                    appModel = this.defaultAppModel;
                }
            }
        }
        Assert.notNull((Object)appModel, "Default ApplicationModel is null");
        return appModel;
    }

    ApplicationModel getDefaultAppModel() {
        return this.defaultAppModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addApplication(ApplicationModel applicationModel) {
        this.checkDestroyed();
        Object object = this.instLock;
        synchronized (object) {
            if (!this.applicationModels.contains(applicationModel)) {
                applicationModel.setInternalId(this.buildInternalId(this.getInternalId(), this.appIndex.getAndIncrement()));
                this.applicationModels.add(applicationModel);
                if (!applicationModel.isInternal()) {
                    this.pubApplicationModels.add(applicationModel);
                }
                this.resetDefaultAppModel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeApplication(ApplicationModel model) {
        Object object = this.instLock;
        synchronized (object) {
            this.applicationModels.remove(model);
            if (!model.isInternal()) {
                this.pubApplicationModels.remove(model);
            }
            this.resetDefaultAppModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryDestroyProtocols() {
        Object object = this.instLock;
        synchronized (object) {
            if (this.pubApplicationModels.size() == 0) {
                this.notifyProtocolDestroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryDestroy() {
        Object object = this.instLock;
        synchronized (object) {
            if (this.pubApplicationModels.size() == 0) {
                this.destroy();
            }
        }
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("FrameworkModel is destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDefaultAppModel() {
        Object object = this.instLock;
        synchronized (object) {
            if (this.defaultAppModel != null && !this.defaultAppModel.isDestroyed()) {
                return;
            }
            ApplicationModel oldDefaultAppModel = this.defaultAppModel;
            this.defaultAppModel = this.pubApplicationModels.size() > 0 ? this.pubApplicationModels.get(0) : null;
            if (defaultInstance == this && oldDefaultAppModel != this.defaultAppModel && LOGGER.isInfoEnabled()) {
                LOGGER.info("Reset global default application from " + FrameworkModel.safeGetModelDesc(oldDefaultAppModel) + " to " + FrameworkModel.safeGetModelDesc(this.defaultAppModel));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetDefaultFrameworkModel() {
        Object object = globalLock;
        synchronized (object) {
            if (defaultInstance != null && !defaultInstance.isDestroyed()) {
                return;
            }
            FrameworkModel oldDefaultFrameworkModel = defaultInstance;
            if (oldDefaultFrameworkModel != (defaultInstance = allInstances.size() > 0 ? allInstances.get(0) : null) && LOGGER.isInfoEnabled()) {
                LOGGER.info("Reset global default framework from " + FrameworkModel.safeGetModelDesc(oldDefaultFrameworkModel) + " to " + FrameworkModel.safeGetModelDesc(defaultInstance));
            }
        }
    }

    private static String safeGetModelDesc(ScopeModel scopeModel) {
        return scopeModel != null ? scopeModel.getDesc() : null;
    }

    public List<ApplicationModel> getApplicationModels() {
        return Collections.unmodifiableList(this.pubApplicationModels);
    }

    public List<ApplicationModel> getAllApplicationModels() {
        return Collections.unmodifiableList(this.applicationModels);
    }

    public ApplicationModel getInternalApplicationModel() {
        return this.internalApplicationModel;
    }

    public FrameworkServiceRepository getServiceRepository() {
        return this.serviceRepository;
    }

    @Override
    public Environment getModelEnvironment() {
        throw new UnsupportedOperationException("Environment is inaccessible for FrameworkModel");
    }

    @Override
    protected boolean checkIfClassLoaderCanRemoved(ClassLoader classLoader) {
        return super.checkIfClassLoaderCanRemoved(classLoader) && this.applicationModels.stream().noneMatch(applicationModel -> applicationModel.containsClassLoader(classLoader));
    }

    static {
        allInstances = new CopyOnWriteArrayList<FrameworkModel>();
    }
}

