/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.infra.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.infra.InfraAdapter;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate
public class EnvironmentAdapter
implements InfraAdapter,
ScopeModelAware {
    private ApplicationModel applicationModel;

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public Map<String, String> getExtraAttributes(Map<String, String> params) {
        String rawKeys;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String rawLabels = ConfigurationUtils.getProperty(this.applicationModel, "dubbo.labels");
        if (StringUtils.isNotEmpty(rawLabels)) {
            String[] labelPairs;
            for (String pair : labelPairs = CommonConstants.SEMICOLON_SPLIT_PATTERN.split(rawLabels)) {
                String[] label = CommonConstants.EQUAL_SPLIT_PATTERN.split(pair);
                if (label.length != 2) continue;
                parameters.put(label[0], label[1]);
            }
        }
        if (StringUtils.isNotEmpty(rawKeys = ConfigurationUtils.getProperty(this.applicationModel, "dubbo.env.keys"))) {
            String[] keys;
            for (String key : keys = CommonConstants.COMMA_SPLIT_PATTERN.split(rawKeys)) {
                String value = ConfigurationUtils.getProperty(this.applicationModel, key);
                if (value == null) continue;
                parameters.put(key, value);
            }
        }
        return parameters;
    }

    @Override
    public String getAttribute(String key) {
        return ConfigurationUtils.getProperty(this.applicationModel, key);
    }
}

