/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.metrics.collector.stat;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.dubbo.common.metrics.collector.stat.MetricsStatHandler;
import org.apache.dubbo.common.metrics.model.MethodMetric;

public class DefaultMetricsStatHandler
implements MetricsStatHandler {
    private final String applicationName;
    private final Map<MethodMetric, AtomicLong> counts = new ConcurrentHashMap<MethodMetric, AtomicLong>();

    public DefaultMetricsStatHandler(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void increase(String interfaceName, String methodName, String group, String version) {
        this.doIncrExecute(interfaceName, methodName, group, version);
    }

    @Override
    public void decrease(String interfaceName, String methodName, String group, String version) {
        this.doDecrExecute(interfaceName, methodName, group, version);
    }

    protected void doExecute(String interfaceName, String methodName, String group, String version, BiConsumer<MethodMetric, Map<MethodMetric, AtomicLong>> execute) {
        MethodMetric metric = new MethodMetric(this.applicationName, interfaceName, methodName, group, version);
        execute.accept(metric, this.counts);
        this.doNotify(metric);
    }

    protected void doIncrExecute(String interfaceName, String methodName, String group, String version) {
        this.doExecute(interfaceName, methodName, group, version, (metric, counts) -> {
            AtomicLong count = counts.computeIfAbsent(metric, k -> new AtomicLong(0L));
            count.incrementAndGet();
        });
    }

    protected void doDecrExecute(String interfaceName, String methodName, String group, String version) {
        this.doExecute(interfaceName, methodName, group, version, (metric, counts) -> {
            AtomicLong count = counts.computeIfAbsent(metric, k -> new AtomicLong(0L));
            count.decrementAndGet();
        });
    }

    @Override
    public Map<MethodMetric, AtomicLong> get() {
        return this.counts;
    }

    public void doNotify(MethodMetric metric) {
    }
}

