/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.threadpool.manager.Ring;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public class FrameworkExecutorRepository
implements Disposable {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(FrameworkExecutorRepository.class);
    private final ExecutorService sharedExecutor;
    private final ScheduledExecutorService sharedScheduledExecutor;
    private final Ring<ScheduledExecutorService> scheduledExecutors = new Ring();
    private final ScheduledExecutorService connectivityScheduledExecutor;
    private final ScheduledExecutorService cacheRefreshingScheduledExecutor;
    private final ExecutorService mappingRefreshingExecutor;
    public final Ring<ScheduledExecutorService> registryNotificationExecutorRing = new Ring();
    private final Ring<ScheduledExecutorService> serviceDiscoveryAddressNotificationExecutorRing = new Ring();
    private final ScheduledExecutorService metadataRetryExecutor;
    private final ExecutorService poolRouterExecutor;
    private final Ring<ExecutorService> executorServiceRing = new Ring();

    public FrameworkExecutorRepository() {
        int i;
        this.sharedExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("Dubbo-framework-shared-handler", true));
        this.sharedScheduledExecutor = Executors.newScheduledThreadPool(8, new NamedThreadFactory("Dubbo-framework-shared-scheduler", true));
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        for (i = 0; i < availableProcessors; ++i) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-scheduler-" + i, true));
            this.scheduledExecutors.addItem(scheduler);
            this.executorServiceRing.addItem(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-framework-state-router-loop-" + i, true), new ThreadPoolExecutor.AbortPolicy()));
        }
        this.connectivityScheduledExecutor = Executors.newScheduledThreadPool(availableProcessors, new NamedThreadFactory("Dubbo-framework-connectivity-scheduler", true));
        this.cacheRefreshingScheduledExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-cache-refreshing-scheduler", true));
        this.mappingRefreshingExecutor = Executors.newFixedThreadPool(availableProcessors, new NamedThreadFactory("Dubbo-framework-mapping-refreshing-scheduler", true));
        this.poolRouterExecutor = new ThreadPoolExecutor(1, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-framework-state-router-pool-router", true), new ThreadPoolExecutor.AbortPolicy());
        for (i = 0; i < availableProcessors; ++i) {
            ScheduledExecutorService serviceDiscoveryAddressNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-SD-address-refresh-" + i));
            ScheduledExecutorService registryNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-registry-notification-" + i));
            this.serviceDiscoveryAddressNotificationExecutorRing.addItem(serviceDiscoveryAddressNotificationExecutor);
            this.registryNotificationExecutorRing.addItem(registryNotificationExecutor);
        }
        this.metadataRetryExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-metadata-retry"));
    }

    public ScheduledExecutorService nextScheduledExecutor() {
        return this.scheduledExecutors.pollItem();
    }

    public ExecutorService nextExecutorExecutor() {
        return this.executorServiceRing.pollItem();
    }

    public ScheduledExecutorService getRegistryNotificationExecutor() {
        return this.registryNotificationExecutorRing.pollItem();
    }

    public ScheduledExecutorService getServiceDiscoveryAddressNotificationExecutor() {
        return this.serviceDiscoveryAddressNotificationExecutorRing.pollItem();
    }

    public ScheduledExecutorService getMetadataRetryExecutor() {
        return this.metadataRetryExecutor;
    }

    public ExecutorService getSharedExecutor() {
        return this.sharedExecutor;
    }

    public ScheduledExecutorService getSharedScheduledExecutor() {
        return this.sharedScheduledExecutor;
    }

    public ExecutorService getPoolRouterExecutor() {
        return this.poolRouterExecutor;
    }

    public ScheduledExecutorService getConnectivityScheduledExecutor() {
        return this.connectivityScheduledExecutor;
    }

    public ScheduledExecutorService getCacheRefreshingScheduledExecutor() {
        return this.cacheRefreshingScheduledExecutor;
    }

    public ExecutorService getMappingRefreshingExecutor() {
        return this.mappingRefreshingExecutor;
    }

    @Override
    public void destroy() {
        logger.info("destroying framework executor repository ..");
        this.shutdownExecutorService(this.poolRouterExecutor, "poolRouterExecutor");
        this.shutdownExecutorService(this.metadataRetryExecutor, "metadataRetryExecutor");
        this.shutdownExecutorServices(this.scheduledExecutors.listItems(), "scheduledExecutors");
        this.shutdownExecutorServices(this.executorServiceRing.listItems(), "executorServiceRing");
        this.shutdownExecutorService(this.connectivityScheduledExecutor, "connectivityScheduledExecutor");
        this.shutdownExecutorService(this.cacheRefreshingScheduledExecutor, "cacheRefreshingScheduledExecutor");
        this.shutdownExecutorService(this.sharedExecutor, "sharedExecutor");
        this.shutdownExecutorService(this.sharedScheduledExecutor, "sharedScheduledExecutor");
        this.shutdownExecutorServices(this.serviceDiscoveryAddressNotificationExecutorRing.listItems(), "serviceDiscoveryAddressNotificationExecutorRing");
        this.shutdownExecutorServices(this.registryNotificationExecutorRing.listItems(), "registryNotificationExecutorRing");
        this.shutdownExecutorService(this.mappingRefreshingExecutor, "mappingRefreshingExecutor");
    }

    private void shutdownExecutorServices(List<? extends ExecutorService> executorServices, String msg) {
        for (ExecutorService executorService : executorServices) {
            this.shutdownExecutorService(executorService, msg);
        }
    }

    private void shutdownExecutorService(ExecutorService executorService, String name) {
        try {
            executorService.shutdownNow();
        }
        catch (Exception e) {
            String msg = "shutdown executor service [" + name + "] failed: ";
            logger.warn("0-17", "", "", msg + e.getMessage(), e);
        }
    }
}

