/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public abstract class ServiceAddressURL
extends URL {
    protected final transient URL consumerURL;
    private transient Map<String, String> concatenatedPrams;

    public ServiceAddressURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, URL consumerURL) {
        super(protocol, username, password, host, port, path, parameters);
        this.consumerURL = consumerURL;
    }

    public ServiceAddressURL(URLAddress urlAddress, URLParam urlParam, URL consumerURL) {
        super(urlAddress, urlParam);
        this.consumerURL = consumerURL;
    }

    @Override
    public String getPath() {
        String path = super.getPath();
        if (StringUtils.isNotEmpty(path)) {
            return path;
        }
        return this.consumerURL.getPath();
    }

    @Override
    public String getServiceInterface() {
        return this.consumerURL.getServiceInterface();
    }

    @Override
    public String getApplication() {
        return this.consumerURL.getApplication();
    }

    @Override
    public String getRemoteApplication() {
        return super.getParameter("application");
    }

    @Override
    public String getGroup() {
        return super.getParameter("group");
    }

    @Override
    public String getVersion() {
        return super.getParameter("version");
    }

    @Override
    public String getParameter(String key) {
        if ("group".equals(key)) {
            return this.getGroup();
        }
        if ("version".equals(key)) {
            return this.getVersion();
        }
        if ("application".equals(key)) {
            return this.getRemoteApplication();
        }
        if ("side".equals(key)) {
            return this.getSide();
        }
        if ("category".equals(key)) {
            return this.getCategory();
        }
        String value = null;
        if (this.consumerURL != null) {
            value = this.consumerURL.getParameter(key);
        }
        if (StringUtils.isEmpty(value)) {
            value = super.getParameter(key);
        }
        return value;
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String value = null;
        if (this.consumerURL != null) {
            value = this.consumerURL.getMethodParameterStrict(method, key);
        }
        if (StringUtils.isEmpty(value)) {
            value = super.getMethodParameterStrict(method, key);
        }
        if (StringUtils.isEmpty(value)) {
            value = this.getParameter(key);
        }
        return value;
    }

    @Override
    public String getAnyMethodParameter(String key) {
        String value = null;
        if (this.consumerURL != null) {
            value = this.consumerURL.getAnyMethodParameter(key);
        }
        if (StringUtils.isEmpty(value)) {
            value = super.getAnyMethodParameter(key);
        }
        return value;
    }

    @Override
    public String getConcatenatedParameter(String key) {
        String value;
        if (this.concatenatedPrams == null) {
            this.concatenatedPrams = new HashMap<String, String>(1);
        }
        if (StringUtils.isNotEmpty(value = this.concatenatedPrams.get(key))) {
            return value;
        }
        String remoteValue = super.getParameter(key);
        String localValue = this.consumerURL.getParameter(key);
        if (remoteValue != null && remoteValue.length() > 0 && localValue != null && localValue.length() > 0) {
            value = remoteValue + "," + localValue;
            this.concatenatedPrams.put(key, value);
            return value;
        }
        if (localValue != null && localValue.length() > 0) {
            value = localValue;
        } else if (remoteValue != null && remoteValue.length() > 0) {
            value = remoteValue;
        }
        this.concatenatedPrams.put(key, value);
        return value;
    }

    @Override
    public String getCategory() {
        return "providers";
    }

    @Override
    public String getSide() {
        return "consumer";
    }

    public URL getConsumerURL() {
        return this.consumerURL;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ScopeModel getScopeModel() {
        return this.consumerURL.getScopeModel();
    }

    @Override
    public ServiceModel getServiceModel() {
        return this.consumerURL.getServiceModel();
    }

    @Override
    public URL setScopeModel(ScopeModel scopeModel) {
        throw new UnsupportedOperationException("setScopeModel is forbidden for ServiceAddressURL");
    }

    @Override
    public URL setServiceModel(ServiceModel serviceModel) {
        throw new UnsupportedOperationException("setServiceModel is forbidden for ServiceAddressURL");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAddressURL)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        URLParam totalParam = this.getUrlParam().addParametersIfAbsent(this.consumerURL.getParameters());
        return new ServiceConfigURL(this.getUrlAddress(), totalParam, null).toString();
    }
}

