/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.dubbo.common.convert.ConverterUtil;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    public static final Set<Class<?>> SIMPLE_TYPES = CollectionUtils.ofSet(Void.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, BigDecimal.class, BigInteger.class, Date.class, Object.class);
    private static final String INTERNAL_ARRAY_PREFIX = "[L";
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new HashMap(32);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new HashMap(16);
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_TYPE_MAP;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final String[] OBJECT_METHODS;

    public static Class<?> forNameWithThreadContextClassLoader(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> forNameWithCallerClassLoader(String name, Class<?> caller) throws ClassNotFoundException {
        return ClassUtils.forName(name, caller.getClassLoader());
    }

    public static ClassLoader getCallerClassLoader(Class<?> caller) {
        return caller.getClassLoader();
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = null;
        if (!clazz.getName().startsWith("org.apache.dubbo")) {
            cl = clazz.getClassLoader();
        }
        if (cl == null) {
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cl == null && (cl = clazz.getClassLoader()) == null) {
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return cl;
    }

    public static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(ClassUtils.class);
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, ClassUtils.getClassLoader());
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        int internalArrayMarker = name.indexOf(INTERNAL_ARRAY_PREFIX);
        if (internalArrayMarker != -1 && name.endsWith(";")) {
            String elementClassName = null;
            if (internalArrayMarker == 0) {
                elementClassName = name.substring(INTERNAL_ARRAY_PREFIX.length(), name.length() - 1);
            } else if (name.startsWith("[")) {
                elementClassName = name.substring(1);
            }
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassUtils.getClassLoader();
        }
        return classLoaderToUse.loadClass(name);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    public static String toShortString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getSimpleName() + "@" + System.identityHashCode(obj);
    }

    public static String simpleClassName(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        String className = clazz.getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className.substring(lastDotIdx + 1);
        }
        return className;
    }

    public static boolean isPrimitive(Class<?> type) {
        return type != null && (type.isPrimitive() || ClassUtils.isSimpleType(type));
    }

    public static boolean isSimpleType(Class<?> type) {
        return SIMPLE_TYPES.contains(type);
    }

    public static Object convertPrimitive(Class<?> type, String value) {
        return ClassUtils.convertPrimitive(FrameworkModel.defaultModel(), type, value);
    }

    public static Object convertPrimitive(FrameworkModel frameworkModel, Class<?> type, String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        Class<?> wrapperType = WRAPPER_PRIMITIVE_TYPE_MAP.getOrDefault(type, type);
        Object result = null;
        try {
            result = frameworkModel.getBeanFactory().getBean(ConverterUtil.class).convertIfPossible(value, wrapperType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isTypeMatch(Class<?> type, String value) {
        return type != Boolean.TYPE && type != Boolean.class || "true".equals(value) || "false".equals(value);
    }

    public static Set<Class<?>> getAllSuperClasses(Class<?> type, Predicate<Class<?>> ... classFilters) {
        LinkedHashSet allSuperClasses = new LinkedHashSet();
        for (Class<?> superClass = type.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            allSuperClasses.add(superClass);
        }
        return Collections.unmodifiableSet(Streams.filterAll(allSuperClasses, classFilters));
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> type, Predicate<Class<?>> ... interfaceFilters) {
        if (type == null || type.isPrimitive()) {
            return Collections.emptySet();
        }
        LinkedHashSet allInterfaces = new LinkedHashSet();
        LinkedHashSet<Class> resolved = new LinkedHashSet<Class>();
        LinkedList waitResolve = new LinkedList();
        resolved.add(type);
        Class clazz = type;
        while (clazz != null) {
            Object[] interfaces = clazz.getInterfaces();
            if (ArrayUtils.isNotEmpty(interfaces)) {
                Arrays.stream(interfaces).filter(resolved::add).forEach(cls -> {
                    allInterfaces.add(cls);
                    waitResolve.add(cls);
                });
            }
            ClassUtils.getAllSuperClasses(clazz, new Predicate[0]).stream().filter(resolved::add).forEach(waitResolve::add);
            clazz = (Class)waitResolve.poll();
        }
        return Streams.filterAll(allInterfaces, interfaceFilters);
    }

    public static Set<Class<?>> getAllInheritedTypes(Class<?> type, Predicate<Class<?>> ... typeFilters) {
        LinkedHashSet types = new LinkedHashSet(ClassUtils.getAllSuperClasses(type, typeFilters));
        types.addAll(ClassUtils.getAllInterfaces(type, typeFilters));
        return Collections.unmodifiableSet(types);
    }

    public static boolean isAssignableFrom(Class<?> superType, Class<?> targetType) {
        if (superType == null || targetType == null) {
            return false;
        }
        if (Objects.equals(superType, targetType)) {
            return true;
        }
        return superType.isAssignableFrom(targetType);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static Class<?> resolveClass(String className, ClassLoader classLoader) {
        Class<?> targetClass = null;
        try {
            targetClass = ClassUtils.forName(className, classLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return targetClass;
    }

    public static boolean isGenericClass(Class<?> type) {
        return type != null && !Void.TYPE.equals(type) && !Void.class.equals(type);
    }

    public static boolean hasMethods(Method[] methods) {
        if (methods == null || methods.length == 0) {
            return false;
        }
        for (Method m : methods) {
            if (m.getDeclaringClass() == Object.class) continue;
            return true;
        }
        return false;
    }

    public static String[] getMethodNames(Class<?> tClass) {
        if (tClass == Object.class) {
            return OBJECT_METHODS;
        }
        Method[] methods = Arrays.stream(tClass.getMethods()).collect(Collectors.toList()).toArray(new Method[0]);
        ArrayList<String> mns = new ArrayList<String>();
        boolean hasMethod = ClassUtils.hasMethods(methods);
        if (hasMethod) {
            for (Method m : methods) {
                if (m.getDeclaringClass() == Object.class) continue;
                String mn = m.getName();
                mns.add(mn);
            }
        }
        return mns.toArray(new String[0]);
    }

    public static String[] getDeclaredMethodNames(Class<?> tClass) {
        if (tClass == Object.class) {
            return OBJECT_METHODS;
        }
        Method[] methods = Arrays.stream(tClass.getMethods()).collect(Collectors.toList()).toArray(new Method[0]);
        ArrayList<String> dmns = new ArrayList<String>();
        boolean hasMethod = ClassUtils.hasMethods(methods);
        if (hasMethod) {
            for (Method m : methods) {
                if (m.getDeclaringClass() == Object.class) continue;
                String mn = m.getName();
                if (m.getDeclaringClass() != tClass) continue;
                dmns.add(mn);
            }
        }
        dmns.sort(Comparator.naturalOrder());
        return dmns.toArray(new String[0]);
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
        HashSet<Class> primitiveTypeNames = new HashSet<Class>(32);
        primitiveTypeNames.addAll(PRIMITIVE_WRAPPER_TYPE_MAP.values());
        primitiveTypeNames.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        for (Class primitiveTypeName : primitiveTypeNames) {
            PRIMITIVE_TYPE_NAME_MAP.put(primitiveTypeName.getName(), primitiveTypeName);
        }
        WRAPPER_PRIMITIVE_TYPE_MAP = CollectionUtils.flip(PRIMITIVE_WRAPPER_TYPE_MAP);
        OBJECT_METHODS = new String[]{"getClass", "hashCode", "toString", "equals"};
    }
}

