/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ModuleConfig
extends AbstractConfig {
    private static final long serialVersionUID = 5508512956753757169L;
    private String name;
    private String version;
    private String owner;
    private String organization;
    private List<RegistryConfig> registries;
    private MonitorConfig monitor;
    private Boolean background;
    private Boolean referAsync;
    private Integer referThreadNum;
    private Boolean exportAsync;
    private Integer exportThreadNum;

    public ModuleConfig() {
    }

    public ModuleConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public ModuleConfig(String name) {
        this();
        this.setName(name);
    }

    public ModuleConfig(ModuleModel moduleModel, String name) {
        this(moduleModel);
        this.setName(name);
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.background == null) {
            this.background = false;
        }
    }

    @Override
    protected void checkScopeModel(ScopeModel scopeModel) {
        if (scopeModel == null) {
            throw new IllegalArgumentException("scopeModel cannot be null");
        }
        if (!(scopeModel instanceof ModuleModel)) {
            throw new IllegalArgumentException("Invalid scope model, expect to be a ModuleModel but got: " + scopeModel);
        }
    }

    @Override
    public ModuleModel getScopeModel() {
        return (ModuleModel)super.getScopeModel();
    }

    @Override
    protected ScopeModel getDefaultModel() {
        return ApplicationModel.defaultModel().getDefaultModule();
    }

    @Parameter(key="module")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Parameter(key="module.version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Parameter(key="module.owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Parameter(key="module.organization")
    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.registries = registries;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    public MonitorConfig getMonitor() {
        return this.monitor;
    }

    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
    }

    public void setMonitor(String monitor) {
        this.monitor = new MonitorConfig(monitor);
    }

    public Boolean getBackground() {
        return this.background;
    }

    public void setBackground(Boolean background) {
        this.background = background;
    }

    public Integer getReferThreadNum() {
        return this.referThreadNum;
    }

    public void setReferThreadNum(Integer referThreadNum) {
        this.referThreadNum = referThreadNum;
    }

    public Integer getExportThreadNum() {
        return this.exportThreadNum;
    }

    public void setExportThreadNum(Integer exportThreadNum) {
        this.exportThreadNum = exportThreadNum;
    }

    public Boolean getReferAsync() {
        return this.referAsync;
    }

    public void setReferAsync(Boolean referAsync) {
        this.referAsync = referAsync;
    }

    public Boolean getExportAsync() {
        return this.exportAsync;
    }

    public void setExportAsync(Boolean exportAsync) {
        this.exportAsync = exportAsync;
    }
}

