/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.Serializable;
import java.util.List;
import org.apache.dubbo.common.utils.Page;

public class DefaultPage<T>
implements Page<T>,
Serializable {
    private static final long serialVersionUID = 1099331838954070419L;
    private final int requestOffset;
    private final int pageSize;
    private final int totalSize;
    private final List<T> data;
    private final int totalPages;
    private final boolean hasNext;

    public DefaultPage(int requestOffset, int pageSize, List<T> data, int totalSize) {
        this.requestOffset = requestOffset;
        this.pageSize = pageSize;
        this.data = data;
        this.totalSize = totalSize;
        int remain = totalSize % pageSize;
        this.totalPages = remain > 0 ? totalSize / pageSize + 1 : totalSize / pageSize;
        this.hasNext = totalSize - requestOffset - pageSize > 0;
    }

    @Override
    public int getOffset() {
        return this.requestOffset;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getTotalPages() {
        return this.totalPages;
    }

    @Override
    public List<T> getData() {
        return this.data;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }
}

