/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassLoaderResourceLoader;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeClassLoaderListener;

public class SerializeSecurityConfigurator
implements ScopeClassLoaderListener<ModuleModel> {
    private final SerializeSecurityManager serializeSecurityManager;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SerializeSecurityConfigurator.class);
    private final ModuleModel moduleModel;
    private volatile boolean autoTrustSerializeClass = true;
    private volatile int trustSerializeClassLevel = Integer.MAX_VALUE;

    public SerializeSecurityConfigurator(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
        moduleModel.addClassLoaderListener(this);
        FrameworkModel frameworkModel = moduleModel.getApplicationModel().getFrameworkModel();
        this.serializeSecurityManager = frameworkModel.getBeanFactory().getBean(SerializeSecurityManager.class);
        this.refreshStatus();
        this.refreshCheck();
        this.refreshConfig();
        this.onAddClassLoader(moduleModel, Thread.currentThread().getContextClassLoader());
    }

    public void refreshCheck() {
        Optional<ApplicationConfig> applicationConfig = this.moduleModel.getApplicationModel().getApplicationConfigManager().getApplication();
        this.autoTrustSerializeClass = applicationConfig.map(ApplicationConfig::getAutoTrustSerializeClass).orElse(true);
        this.trustSerializeClassLevel = applicationConfig.map(ApplicationConfig::getTrustSerializeClassLevel).orElse(3);
        this.serializeSecurityManager.setCheckSerializable(applicationConfig.map(ApplicationConfig::getCheckSerializable).orElse(true));
    }

    @Override
    public void onAddClassLoader(ModuleModel scopeModel, ClassLoader classLoader) {
        this.refreshClassLoader(classLoader);
    }

    @Override
    public void onRemoveClassLoader(ModuleModel scopeModel, ClassLoader classLoader) {
    }

    private void refreshClassLoader(ClassLoader classLoader) {
        this.loadAllow(classLoader);
        this.loadBlocked(classLoader);
    }

    private void refreshConfig() {
        String[] classStrings;
        String allowedClassList = System.getProperty("dubbo.security.serialize.allowedClassList", "").trim();
        String blockedClassList = System.getProperty("dubbo.security.serialize.blockedClassList", "").trim();
        if (StringUtils.isNotEmpty(allowedClassList)) {
            for (String className : classStrings = allowedClassList.trim().split(",")) {
                if (!StringUtils.isNotEmpty(className = className.trim())) continue;
                this.serializeSecurityManager.addToAlwaysAllowed(className);
            }
        }
        if (StringUtils.isNotEmpty(blockedClassList)) {
            for (String className : classStrings = blockedClassList.trim().split(",")) {
                if (!StringUtils.isNotEmpty(className = className.trim())) continue;
                this.serializeSecurityManager.addToDisAllowed(className);
            }
        }
    }

    private void loadAllow(ClassLoader classLoader) {
        Set<URL> urls = ClassLoaderResourceLoader.loadResources("security/serialize.allowlist", classLoader);
        for (URL u : urls) {
            try {
                String[] lines;
                logger.info("Read serialize allow list from " + u);
                for (String line : lines = IOUtils.readLines(u.openStream())) {
                    if (StringUtils.isEmpty(line = line.trim()) || line.startsWith("#")) continue;
                    this.serializeSecurityManager.addToAlwaysAllowed(line);
                }
            }
            catch (IOException e) {
                logger.error("0-22", "", "", "Failed to load allow class list! Will ignore allow lis from " + u, e);
            }
        }
    }

    private void loadBlocked(ClassLoader classLoader) {
        Set<URL> urls = ClassLoaderResourceLoader.loadResources("security/serialize.blockedlist", classLoader);
        for (URL u : urls) {
            try {
                String[] lines;
                logger.info("Read serialize blocked list from " + u);
                for (String line : lines = IOUtils.readLines(u.openStream())) {
                    if (StringUtils.isEmpty(line = line.trim()) || line.startsWith("#")) continue;
                    this.serializeSecurityManager.addToDisAllowed(line);
                }
            }
            catch (IOException e) {
                logger.error("0-22", "", "", "Failed to load blocked class list! Will ignore blocked lis from " + u, e);
            }
        }
    }

    public void refreshStatus() {
        Optional<ApplicationConfig> application = this.moduleModel.getApplicationModel().getApplicationConfigManager().getApplication();
        String statusString = application.map(ApplicationConfig::getSerializeCheckStatus).orElse(null);
        SerializeCheckStatus checkStatus = null;
        if (StringUtils.isEmpty(statusString)) {
            String blockAllClassExceptAllow;
            String openCheckClass = System.getProperty("dubbo.security.serialize.openCheckClass", "true");
            if (!Boolean.parseBoolean(openCheckClass)) {
                checkStatus = SerializeCheckStatus.DISABLE;
            }
            if (Boolean.parseBoolean(blockAllClassExceptAllow = System.getProperty("dubbo.security.serialize.blockAllClassExceptAllow", "false"))) {
                checkStatus = SerializeCheckStatus.STRICT;
            }
        } else {
            checkStatus = SerializeCheckStatus.valueOf(statusString);
        }
        if (checkStatus != null) {
            this.serializeSecurityManager.setCheckStatus(checkStatus);
        }
    }

    public synchronized void registerInterface(Class<?> clazz) {
        Method[] methodsToExport;
        if (!this.autoTrustSerializeClass) {
            return;
        }
        HashSet<Type> markedClass = new HashSet<Type>();
        markedClass.add(clazz);
        this.checkClass(markedClass, clazz);
        this.addToAllow(clazz.getName());
        for (Method method : methodsToExport = clazz.getMethods()) {
            Type[] typeArray;
            Class<?>[] exceptionTypes;
            Type[] genericParameterTypes;
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                this.checkClass(markedClass, parameterType);
            }
            for (Type type : genericParameterTypes = method.getGenericParameterTypes()) {
                this.checkType(markedClass, type);
            }
            Class<?> returnType = method.getReturnType();
            this.checkClass(markedClass, returnType);
            Type genericReturnType = method.getGenericReturnType();
            this.checkType(markedClass, genericReturnType);
            for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
                this.checkClass(markedClass, exceptionType);
            }
            for (Type genericExceptionType : typeArray = method.getGenericExceptionTypes()) {
                this.checkType(markedClass, genericExceptionType);
            }
        }
    }

    private void checkType(Set<Type> markedClass, Type type) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (type instanceof Class) {
                            this.checkClass(markedClass, (Class)type);
                            return;
                        }
                        if (!markedClass.add(type)) {
                            return;
                        }
                        if (!(type instanceof ParameterizedType)) break block6;
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        this.checkClass(markedClass, (Class)parameterizedType.getRawType());
                        for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                            this.checkType(markedClass, actualTypeArgument);
                        }
                        break block7;
                    }
                    if (!(type instanceof GenericArrayType)) break block8;
                    GenericArrayType genericArrayType = (GenericArrayType)type;
                    this.checkType(markedClass, genericArrayType.getGenericComponentType());
                    break block7;
                }
                if (!(type instanceof TypeVariable)) break block9;
                TypeVariable typeVariable = (TypeVariable)type;
                for (Type bound : typeVariable.getBounds()) {
                    this.checkType(markedClass, bound);
                }
                break block7;
            }
            if (!(type instanceof WildcardType)) break block7;
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                this.checkType(markedClass, bound);
            }
            for (Type bound : wildcardType.getLowerBounds()) {
                this.checkType(markedClass, bound);
            }
        }
    }

    private void checkClass(Set<Type> markedClass, Class<?> clazz) {
        Field[] fields;
        Class<?>[] interfaces;
        if (!markedClass.add(clazz)) {
            return;
        }
        this.addToAllow(clazz.getName());
        for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
            this.checkClass(markedClass, interfaceClass);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.checkClass(markedClass, superclass);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<?> fieldClass = field.getType();
            this.checkClass(markedClass, fieldClass);
            this.checkType(markedClass, field.getGenericType());
        }
    }

    private void addToAllow(String className) {
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.sun.") || className.startsWith("sun.") || className.startsWith("jdk.")) {
            this.serializeSecurityManager.addToAllowed(className);
            return;
        }
        String[] subs = className.split("\\.");
        if (subs.length > this.trustSerializeClassLevel) {
            this.serializeSecurityManager.addToAllowed(Arrays.stream(subs).limit(this.trustSerializeClassLevel).collect(Collectors.joining(".")) + ".");
        } else {
            this.serializeSecurityManager.addToAllowed(className);
        }
    }
}

