/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class ThreadlessExecutor
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadlessExecutor.class.getName());
    private static final Object SHUTDOWN = new Object();
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicReference<Object> waiter = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndDrain(long deadline) throws InterruptedException {
        ThreadlessExecutor.throwIfInterrupted();
        Runnable runnable = this.queue.poll();
        if (runnable == null && this.waiter.compareAndSet(null, Thread.currentThread())) {
            try {
                while ((runnable = this.queue.poll()) == null && this.waiter.get() == Thread.currentThread()) {
                    long restTime = deadline - System.nanoTime();
                    if (restTime <= 0L) {
                        return;
                    }
                    LockSupport.parkNanos(this, restTime);
                    ThreadlessExecutor.throwIfInterrupted();
                }
            }
            finally {
                this.waiter.compareAndSet(Thread.currentThread(), null);
            }
        }
        do {
            if (runnable == null) continue;
            runnable.run();
        } while ((runnable = this.queue.poll()) != null);
    }

    private static void throwIfInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        RunnableWrapper run = new RunnableWrapper(runnable);
        this.queue.add(run);
        if (this.waiter.get() != SHUTDOWN) {
            LockSupport.unpark((Thread)this.waiter.get());
        } else if (this.queue.remove(run)) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    @Override
    public List<Runnable> shutdownNow() {
        Runnable runnable;
        if (this.waiter.get() != SHUTDOWN) {
            LockSupport.unpark((Thread)this.waiter.get());
        }
        this.waiter.set(SHUTDOWN);
        while ((runnable = this.queue.poll()) != null) {
            runnable.run();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.waiter.get() == SHUTDOWN;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    private static class RunnableWrapper
    implements Runnable {
        private final Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                logger.info(t);
            }
        }
    }
}

