/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.dubbo.common.resource.Disposable;

public class CallableSafeInitializer<T> {
    private final AtomicReference<CallableSafeInitializer<T>> factory = new AtomicReference();
    private final AtomicReference<T> reference = new AtomicReference();
    private final Callable<T> callable;

    public CallableSafeInitializer(Callable<T> callable) {
        this.callable = callable;
    }

    public final T get() {
        T result;
        while ((result = this.reference.get()) == null) {
            if (!this.factory.compareAndSet(null, this)) continue;
            this.reference.set(this.initialize());
        }
        return result;
    }

    protected T initialize() {
        try {
            return this.callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public T remove() {
        return this.remove(null);
    }

    public T remove(Consumer<? super T> action) {
        T value = this.reference.getAndSet(null);
        if (value != null) {
            if (action != null) {
                action.accept(value);
            }
            if (value instanceof Disposable) {
                ((Disposable)value).destroy();
            }
        }
        this.factory.set(null);
        return value;
    }
}

