/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.json.JSON;
import org.apache.dubbo.common.json.impl.AbstractJSONImpl;
import org.apache.dubbo.common.json.impl.FastJson2Impl;
import org.apache.dubbo.common.json.impl.FastJsonImpl;
import org.apache.dubbo.common.json.impl.GsonImpl;
import org.apache.dubbo.common.json.impl.JacksonImpl;
import org.apache.dubbo.common.utils.StringUtils;

public class JsonUtils {
    private static volatile JSON json;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static JSON getJson() {
        if (json != null) return json;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (json != null) return json;
            String preferJsonFrameworkName = System.getProperty("dubbo.json-framework.prefer");
            if (StringUtils.isNotEmpty(preferJsonFrameworkName)) {
                try {
                    AbstractJSONImpl instance = null;
                    switch (preferJsonFrameworkName) {
                        case "fastjson2": {
                            instance = new FastJson2Impl();
                            break;
                        }
                        case "fastjson": {
                            instance = new FastJsonImpl();
                            break;
                        }
                        case "gson": {
                            instance = new GsonImpl();
                            break;
                        }
                        case "jackson": {
                            instance = new JacksonImpl();
                        }
                    }
                    if (instance != null && instance.isSupport()) {
                        json = instance;
                    }
                }
                catch (Throwable instance) {
                    // empty catch block
                }
            }
            if (json == null) {
                List<Class> jsonClasses = Arrays.asList(FastJson2Impl.class, FastJsonImpl.class, GsonImpl.class, JacksonImpl.class);
                for (Class jsonClass : jsonClasses) {
                    try {
                        JSON instance = (JSON)jsonClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!instance.isSupport()) continue;
                        json = instance;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            if (json != null) return json;
            throw new IllegalStateException("Dubbo unable to find out any json framework (e.g. fastjson2, fastjson, gson, jackson) from jvm env. Please import at least one json framework.");
        }
    }

    @Deprecated
    protected static void setJson(JSON json) {
        JsonUtils.json = json;
    }

    public static <T> T toJavaObject(String json, Type type) {
        return JsonUtils.getJson().toJavaObject(json, type);
    }

    public static <T> List<T> toJavaList(String json, Class<T> clazz) {
        return JsonUtils.getJson().toJavaList(json, clazz);
    }

    public static String toJson(Object obj) {
        return JsonUtils.getJson().toJson(obj);
    }

    public static List<?> getList(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getList(obj, key);
    }

    public static List<Map<String, ?>> getListOfObjects(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getListOfObjects(obj, key);
    }

    public static List<String> getListOfStrings(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getListOfStrings(obj, key);
    }

    public static Map<String, ?> getObject(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getObject(obj, key);
    }

    public static Double getNumberAsDouble(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsDouble(obj, key);
    }

    public static Integer getNumberAsInteger(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsInteger(obj, key);
    }

    public static Long getNumberAsLong(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsLong(obj, key);
    }

    public static String getString(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getString(obj, key);
    }

    public static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        return JsonUtils.getJson().checkObjectList(rawList);
    }

    public static List<String> checkStringList(List<?> rawList) {
        return JsonUtils.getJson().checkStringList(rawList);
    }
}

