/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger.slf4j;

import java.io.File;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerAdapter;
import org.apache.dubbo.common.logger.slf4j.Slf4jLogger;
import org.apache.dubbo.common.utils.ClassUtils;
import org.slf4j.LoggerFactory;

public class Slf4jLoggerAdapter
implements LoggerAdapter {
    public static final String NAME = "slf4j";
    private Level level = Slf4jLogger.getLevel(ROOT_LOGGER);
    private File file;
    private static final org.slf4j.Logger ROOT_LOGGER = LoggerFactory.getLogger((String)"ROOT");

    @Override
    public Logger getLogger(String key) {
        return new Slf4jLogger(LoggerFactory.getLogger((String)key));
    }

    @Override
    public Logger getLogger(Class<?> key) {
        return new Slf4jLogger(LoggerFactory.getLogger(key));
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        System.err.printf("The level of slf4j logger current can not be set, using the default level: %s \n", new Object[]{Slf4jLogger.getLevel(ROOT_LOGGER)});
        this.level = level;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public boolean isConfigured() {
        try {
            ClassUtils.forName("org.slf4j.impl.StaticLoggerBinder");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

