/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public class GlobalResourcesRepository {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(GlobalResourcesRepository.class);
    private static volatile GlobalResourcesRepository instance;
    private volatile ExecutorService executorService;
    private final List<Disposable> oneoffDisposables = new CopyOnWriteArrayList<Disposable>();
    private static final List<Disposable> globalReusedDisposables;

    private GlobalResourcesRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalResourcesRepository getInstance() {
        if (instance != null) return instance;
        Class<GlobalResourcesRepository> clazz = GlobalResourcesRepository.class;
        synchronized (GlobalResourcesRepository.class) {
            if (instance != null) return instance;
            instance = new GlobalResourcesRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerGlobalDisposable(Disposable disposable) {
        if (globalReusedDisposables.contains(disposable)) return;
        Class<GlobalResourcesRepository> clazz = GlobalResourcesRepository.class;
        synchronized (GlobalResourcesRepository.class) {
            if (globalReusedDisposables.contains(disposable)) return;
            globalReusedDisposables.add(disposable);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeGlobalDisposable(Disposable disposable) {
        if (!globalReusedDisposables.contains(disposable)) return;
        Class<GlobalResourcesRepository> clazz = GlobalResourcesRepository.class;
        synchronized (GlobalResourcesRepository.class) {
            if (!globalReusedDisposables.contains(disposable)) return;
            globalReusedDisposables.remove(disposable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ExecutorService getGlobalExecutorService() {
        return GlobalResourcesRepository.getInstance().getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getExecutorService() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            GlobalResourcesRepository globalResourcesRepository = this;
            synchronized (globalResourcesRepository) {
                if (this.executorService == null || this.executorService.isShutdown()) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Creating global shared handler ...");
                    }
                    this.executorService = Executors.newCachedThreadPool(new NamedThreadFactory("Dubbo-global-shared-handler", true));
                }
            }
        }
        return this.executorService;
    }

    public synchronized void destroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Destroying global resources ...");
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            try {
                if (!this.executorService.awaitTermination(ConfigurationUtils.reCalShutdownTime(10000), TimeUnit.MILLISECONDS)) {
                    logger.warn("0-12", "", "", "Wait global executor service terminated timeout.");
                }
            }
            catch (InterruptedException e) {
                logger.warn("0-12", "", "", "destroy resources failed: " + e.getMessage(), e);
            }
            this.executorService = null;
        }
        for (Disposable disposable : new ArrayList<Disposable>(this.oneoffDisposables)) {
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                logger.warn("0-12", "", "", "destroy resources failed: " + e.getMessage(), e);
            }
        }
        this.oneoffDisposables.clear();
        for (Disposable disposable : new ArrayList<Disposable>(globalReusedDisposables)) {
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                logger.warn("0-12", "", "", "destroy resources failed: " + e.getMessage(), e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Dubbo is completely destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisposable(Disposable disposable) {
        if (!this.oneoffDisposables.contains(disposable)) {
            GlobalResourcesRepository globalResourcesRepository = this;
            synchronized (globalResourcesRepository) {
                if (!this.oneoffDisposables.contains(disposable)) {
                    this.oneoffDisposables.add(disposable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisposable(Disposable disposable) {
        if (this.oneoffDisposables.contains(disposable)) {
            GlobalResourcesRepository globalResourcesRepository = this;
            synchronized (globalResourcesRepository) {
                if (this.oneoffDisposables.contains(disposable)) {
                    this.oneoffDisposables.remove(disposable);
                }
            }
        }
    }

    public static List<Disposable> getGlobalReusedDisposables() {
        return globalReusedDisposables;
    }

    public List<Disposable> getOneoffDisposables() {
        return this.oneoffDisposables;
    }

    static {
        globalReusedDisposables = new CopyOnWriteArrayList<Disposable>();
    }
}

