/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.function.Predicates;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.ClassUtils;

public interface TypeUtils {
    public static final Predicate<Class<?>> NON_OBJECT_TYPE_FILTER = t -> !Objects.equals(Object.class, t);

    public static boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static Type getRawType(Type type) {
        if (TypeUtils.isParameterizedType(type)) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    public static Class<?> getRawClass(Type type) {
        Type rawType = TypeUtils.getRawType(type);
        if (TypeUtils.isClass(rawType)) {
            return (Class)rawType;
        }
        return null;
    }

    public static boolean isClass(Type type) {
        return type instanceof Class;
    }

    public static <T> Class<T> findActualTypeArgument(Type type, Class<?> interfaceClass, int index) {
        return TypeUtils.findActualTypeArguments(type, interfaceClass).get(index);
    }

    public static List<Class<?>> findActualTypeArguments(Type type, Class<?> interfaceClass) {
        ArrayList actualTypeArguments = new ArrayList();
        TypeUtils.getAllGenericTypes(type, t -> ClassUtils.isAssignableFrom(interfaceClass, TypeUtils.getRawClass(t))).forEach(parameterizedType -> {
            Class<?> rawClass = TypeUtils.getRawClass(parameterizedType);
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                if (!(typeArgument instanceof Class)) continue;
                actualTypeArguments.add(i, (Class)typeArgument);
            }
            Class<?> superClass = rawClass.getSuperclass();
            if (superClass != null) {
                actualTypeArguments.addAll(TypeUtils.findActualTypeArguments(superClass, interfaceClass));
            }
        });
        return Collections.unmodifiableList(actualTypeArguments);
    }

    public static List<ParameterizedType> getGenericTypes(Type type, Predicate<ParameterizedType> ... typeFilters) {
        Class<?> rawClass = TypeUtils.getRawClass(type);
        if (rawClass == null) {
            return Collections.emptyList();
        }
        LinkedList<Type> genericTypes = new LinkedList<Type>();
        genericTypes.add(rawClass.getGenericSuperclass());
        genericTypes.addAll(Arrays.asList(rawClass.getGenericInterfaces()));
        return Collections.unmodifiableList(Streams.filterList(genericTypes, TypeUtils::isParameterizedType).stream().map(ParameterizedType.class::cast).filter(Predicates.and(typeFilters)).collect(Collectors.toList()));
    }

    public static List<ParameterizedType> getAllGenericTypes(Type type, Predicate<ParameterizedType> ... typeFilters) {
        LinkedList<ParameterizedType> allGenericTypes = new LinkedList<ParameterizedType>();
        allGenericTypes.addAll(TypeUtils.getAllGenericSuperClasses(type, typeFilters));
        allGenericTypes.addAll(TypeUtils.getAllGenericInterfaces(type, typeFilters));
        return Collections.unmodifiableList(allGenericTypes);
    }

    public static List<ParameterizedType> getAllGenericSuperClasses(Type type, Predicate<ParameterizedType> ... typeFilters) {
        Class<?> rawClass = TypeUtils.getRawClass(type);
        if (rawClass == null || rawClass.isInterface()) {
            return Collections.emptyList();
        }
        LinkedList allTypes = new LinkedList();
        allTypes.add(rawClass);
        allTypes.addAll(ClassUtils.getAllSuperClasses(rawClass, NON_OBJECT_TYPE_FILTER));
        List allGenericSuperClasses = allTypes.stream().map(Class::getGenericSuperclass).filter(TypeUtils::isParameterizedType).map(ParameterizedType.class::cast).collect(Collectors.toList());
        return Collections.unmodifiableList(Streams.filterAll(allGenericSuperClasses, typeFilters));
    }

    public static List<ParameterizedType> getAllGenericInterfaces(Type type, Predicate<ParameterizedType> ... typeFilters) {
        Class<?> rawClass = TypeUtils.getRawClass(type);
        if (rawClass == null) {
            return Collections.emptyList();
        }
        LinkedList allTypes = new LinkedList();
        allTypes.add(rawClass);
        allTypes.addAll(ClassUtils.getAllSuperClasses(rawClass, NON_OBJECT_TYPE_FILTER));
        allTypes.addAll(ClassUtils.getAllInterfaces(rawClass, new Predicate[0]));
        List allGenericInterfaces = allTypes.stream().map(Class::getGenericInterfaces).map(Arrays::asList).flatMap(Collection::stream).filter(TypeUtils::isParameterizedType).map(ParameterizedType.class::cast).collect(Collectors.toList());
        return Collections.unmodifiableList(Streams.filterAll(allGenericInterfaces, typeFilters));
    }

    public static String getClassName(Type type) {
        return TypeUtils.getRawType(type).getTypeName();
    }

    public static Set<String> getClassNames(Iterable<? extends Type> types) {
        return StreamSupport.stream(types.spliterator(), false).map(TypeUtils::getClassName).collect(Collectors.toSet());
    }

    public static Class<?> getSuperGenericType(Class<?> clazz, int index) {
        Class<?> result = TypeUtils.getArgumentClass(clazz.getGenericSuperclass(), index);
        return result == null ? TypeUtils.getArgumentClass(ArrayUtils.first(clazz.getGenericInterfaces()), index) : result;
    }

    public static Class<?> getArgumentClass(Type type, int index) {
        Type[] typeArgs;
        if (type instanceof ParameterizedType && index < (typeArgs = ((ParameterizedType)type).getActualTypeArguments()).length) {
            Type typeArg = typeArgs[index];
            if (typeArg instanceof Class) {
                return (Class)typeArg;
            }
            if (typeArg instanceof ParameterizedType) {
                return (Class)((ParameterizedType)typeArg).getRawType();
            }
        }
        return null;
    }
}

