/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.MethodStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.MetricsExport;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class BaseStatComposite
implements MetricsExport {
    private ApplicationStatComposite applicationStatComposite;
    private ServiceStatComposite serviceStatComposite;
    private MethodStatComposite methodStatComposite;
    private RtStatComposite rtStatComposite;

    public BaseStatComposite(ApplicationModel applicationModel) {
        this.init(new ApplicationStatComposite(applicationModel));
        this.init(new ServiceStatComposite(applicationModel));
        this.init(new MethodStatComposite(applicationModel));
        this.init(new RtStatComposite(applicationModel));
    }

    protected void init(ApplicationStatComposite applicationStatComposite) {
        this.applicationStatComposite = applicationStatComposite;
    }

    protected void init(ServiceStatComposite serviceStatComposite) {
        this.serviceStatComposite = serviceStatComposite;
    }

    protected void init(MethodStatComposite methodStatComposite) {
        this.methodStatComposite = methodStatComposite;
    }

    protected void init(RtStatComposite rtStatComposite) {
        this.rtStatComposite = rtStatComposite;
    }

    public void calcApplicationRt(String registryOpType, Long responseTime) {
        this.rtStatComposite.calcApplicationRt(registryOpType, responseTime);
    }

    public void calcServiceKeyRt(String serviceKey, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcServiceKeyRt(serviceKey, registryOpType, responseTime);
    }

    public void calcMethodKeyRt(Invocation invocation, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcMethodKeyRt(invocation, registryOpType, responseTime);
    }

    public void setServiceKey(MetricsKeyWrapper metricsKey, String serviceKey, int num) {
        this.serviceStatComposite.setServiceKey(metricsKey, serviceKey, num);
    }

    public void incrementApp(MetricsKey metricsKey, int size) {
        this.applicationStatComposite.incrementSize(metricsKey, size);
    }

    public void incrementServiceKey(MetricsKeyWrapper metricsKeyWrapper, String attServiceKey, int size) {
        this.serviceStatComposite.incrementServiceKey(metricsKeyWrapper, attServiceKey, size);
    }

    public void incrementMethodKey(MetricsKeyWrapper metricsKeyWrapper, Invocation invocation, int size) {
        this.methodStatComposite.incrementMethodKey(metricsKeyWrapper, invocation, size);
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        list.addAll(this.applicationStatComposite.export(category));
        list.addAll(this.rtStatComposite.export(category));
        list.addAll(this.serviceStatComposite.export(category));
        list.addAll(this.methodStatComposite.export(category));
        return list;
    }

    public ApplicationStatComposite getApplicationStatComposite() {
        return this.applicationStatComposite;
    }

    public RtStatComposite getRtStatComposite() {
        return this.rtStatComposite;
    }
}

