/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.MetricsDispatcher;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsEventBus {
    public static void publish(MetricsEvent event) {
        if (event.getSource() == null) {
            return;
        }
        ApplicationModel applicationModel = event.getSource();
        if (applicationModel.isDestroyed()) {
            return;
        }
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (beanFactory.isDestroyed()) {
            return;
        }
        MetricsDispatcher dispatcher = (MetricsDispatcher)beanFactory.getBean(MetricsDispatcher.class);
        Optional.ofNullable(dispatcher).ifPresent(d -> d.publishEvent(event));
    }

    public static <T> T post(MetricsEvent event, Supplier<T> targetSupplier) {
        return MetricsEventBus.post(event, targetSupplier, null);
    }

    public static <T> T post(MetricsEvent event, Supplier<T> targetSupplier, Function<T, Boolean> trFunction) {
        T result;
        MetricsEventBus.before(event);
        if (trFunction == null) {
            try {
                result = targetSupplier.get();
            }
            catch (Throwable e) {
                MetricsEventBus.error(event);
                throw e;
            }
            MetricsEventBus.after(event, result);
        } else {
            result = targetSupplier.get();
            if (trFunction.apply(result).booleanValue()) {
                MetricsEventBus.after(event, result);
            } else {
                MetricsEventBus.error(event);
            }
        }
        return result;
    }

    public static void before(MetricsEvent event) {
        MetricsEventBus.before(event, null);
    }

    public static void before(MetricsEvent event, Runnable eventSaveRunner) {
        MetricsDispatcher dispatcher = MetricsEventBus.validate(event);
        if (dispatcher == null) {
            return;
        }
        dispatcher.publishEvent(event);
        if (eventSaveRunner != null) {
            eventSaveRunner.run();
        }
    }

    public static void after(MetricsEvent event, Object result) {
        MetricsDispatcher dispatcher = MetricsEventBus.validate(event);
        if (dispatcher == null) {
            return;
        }
        event.customAfterPost(result);
        dispatcher.publishFinishEvent((TimeCounterEvent)event);
    }

    public static void error(MetricsEvent event) {
        MetricsDispatcher dispatcher = MetricsEventBus.validate(event);
        if (dispatcher == null) {
            return;
        }
        dispatcher.publishErrorEvent((TimeCounterEvent)event);
    }

    private static MetricsDispatcher validate(MetricsEvent event) {
        if (event.getSource() == null) {
            return null;
        }
        ApplicationModel applicationModel = event.getSource();
        if (applicationModel.isDestroyed()) {
            return null;
        }
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (beanFactory.isDestroyed()) {
            return null;
        }
        MetricsDispatcher dispatcher = (MetricsDispatcher)beanFactory.getBean(MetricsDispatcher.class);
        if (dispatcher == null) {
            return null;
        }
        if (!(event instanceof TimeCounterEvent)) {
            return null;
        }
        return dispatcher;
    }
}

