/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ApplicationMetric
implements Metric {
    private final ApplicationModel applicationModel;
    private static final String version = Version.getVersion();
    private static final String commitId = Version.getLastCommitId();

    public ApplicationMetric(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public String getApplicationName() {
        return this.getApplicationModel().getApplicationName();
    }

    public String getData() {
        return version;
    }

    @Override
    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.getApplicationName());
        tags.put("application.version", version);
        tags.put(MetricsKey.METADATA_GIT_COMMITID_METRIC.getName(), commitId);
        return tags;
    }
}

