/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.listener.MetricsListener;

public class SimpleMetricsEventMulticaster
implements MetricsEventMulticaster {
    private final List<MetricsListener<?>> listeners = Collections.synchronizedList(new ArrayList());

    @Override
    public void addListener(MetricsListener<?> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void publishEvent(MetricsEvent event) {
        if (this.validateIfApplicationConfigExist(event)) {
            return;
        }
        for (MetricsListener<?> listener : this.listeners) {
            if (!listener.isSupport(event)) continue;
            listener.onEvent(event);
        }
    }

    private boolean validateIfApplicationConfigExist(MetricsEvent event) {
        if (event.getSource() != null) {
            return StringUtils.isEmpty((String)event.appName());
        }
        return false;
    }

    @Override
    public void publishFinishEvent(TimeCounterEvent event) {
        this.publishTimeEvent(event, metricsLifeListener -> metricsLifeListener.onEventFinish(event));
    }

    @Override
    public void publishErrorEvent(TimeCounterEvent event) {
        this.publishTimeEvent(event, metricsLifeListener -> metricsLifeListener.onEventError(event));
    }

    private void publishTimeEvent(MetricsEvent event, Consumer<MetricsLifeListener> consumer) {
        if (this.validateIfApplicationConfigExist(event)) {
            return;
        }
        if (event instanceof TimeCounterEvent) {
            ((TimeCounterEvent)event).getTimePair().end();
        }
        for (MetricsListener<?> listener : this.listeners) {
            if (!(listener instanceof MetricsLifeListener) || !listener.isSupport(event)) continue;
            consumer.accept((MetricsLifeListener)listener);
        }
    }
}

