/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RequestEvent
extends TimeCounterEvent {
    public RequestEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel, typeWrapper);
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (!beanFactory.isDestroyed()) {
            DefaultMetricsCollector collector = (DefaultMetricsCollector)((Object)beanFactory.getBean(DefaultMetricsCollector.class));
            super.setAvailable(collector != null && collector.isCollectEnabled());
        }
    }

    public static RequestEvent toRequestEvent(ApplicationModel applicationModel, Invocation invocation) {
        RequestEvent requestEvent = new RequestEvent(applicationModel, new TypeWrapper(MetricsLevel.SERVICE, MetricsKey.METRIC_REQUESTS, MetricsKey.METRIC_REQUESTS_SUCCEED, MetricsKey.METRIC_REQUEST_BUSINESS_FAILED)){

            public void customAfterPost(Object postResult) {
                if (postResult == null) {
                    return;
                }
                if (!(postResult instanceof Result)) {
                    throw new MetricsNeverHappenException("Result type error, postResult:" + postResult.getClass().getName());
                }
                super.putAttachment("metric_filter_throwable", (Object)((Result)postResult).getException());
            }
        };
        requestEvent.putAttachment("metric_filter_invocation", invocation);
        requestEvent.putAttachment("serviceKey", MetricsSupport.getInterfaceName((Invocation)invocation));
        requestEvent.putAttachment("metric_filter_side", MetricsSupport.getSide((Invocation)invocation));
        return requestEvent;
    }
}

