/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.ErrorCodeMetricsListenRegister;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsNameCountSampler;
import org.apache.dubbo.metrics.model.ErrorCodeMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.CounterMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;

public class ErrorCodeSampler
extends MetricsNameCountSampler<String, String, ErrorCodeMetric> {
    private final ErrorCodeMetricsListenRegister register = new ErrorCodeMetricsListenRegister(this);
    private final Map<String, ErrorCodeMetric> errorCodeMetrics = new ConcurrentHashMap<String, ErrorCodeMetric>();

    public ErrorCodeSampler(DefaultMetricsCollector collector) {
        super(collector, MetricsCategory.ERROR_CODE, MetricsKey.ERROR_CODE_COUNT);
    }

    @Override
    protected MetricSample provideMetricsSample(ErrorCodeMetric metric, AtomicLong count, MetricsKey metricsKey, MetricsCategory metricsCategory) {
        return new CounterMetricSample(metricsKey.getNameByType(metric.getErrorCode()), metricsKey.getDescription(), metric.getTags(), metricsCategory, (Number)count);
    }

    @Override
    protected void countConfigure(MetricsCountSampleConfigurer<String, String, ErrorCodeMetric> sampleConfigure) {
        sampleConfigure.configureMetrics(configure -> {
            String errorCode = (String)configure.getSource();
            ErrorCodeMetric metric = this.errorCodeMetrics.get(errorCode);
            if (metric == null) {
                metric = new ErrorCodeMetric(this.collector.getApplicationModel().getApplicationName(), errorCode);
                this.errorCodeMetrics.put(errorCode, metric);
            }
            return metric;
        });
    }
}

