/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceNameMapping
implements ServiceNameMapping {
    private static final List<String> IGNORED_SERVICE_INTERFACES = Arrays.asList(MetadataService.class.getName());

    public void map(URL url) {
        String serviceInterface = url.getServiceInterface();
        if (IGNORED_SERVICE_INTERFACES.contains(serviceInterface)) {
            return;
        }
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = MetadataReportInstance.getMetadataReport((String)registryCluster);
        metadataReport.registerServiceAppMapping(ServiceNameMapping.buildGroup((String)serviceInterface), ApplicationModel.getName(), url);
    }

    public Set<String> getAndListen(URL url, MappingListener mappingListener) {
        String serviceInterface = url.getServiceInterface();
        String mappingKey = ServiceNameMapping.buildGroup((String)serviceInterface);
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = MetadataReportInstance.getMetadataReport((String)registryCluster);
        Set apps = metadataReport.getServiceAppMapping(mappingKey, mappingListener, url);
        if (CollectionUtils.isNotEmpty((Collection)apps)) {
            serviceNames.addAll(apps);
        }
        return serviceNames;
    }

    protected String getRegistryCluster(URL url) {
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        int i = registryCluster.indexOf(",");
        if (i > 0) {
            registryCluster = registryCluster.substring(0, i);
        }
        return registryCluster;
    }
}

